# Generated by default/object.tt
package Paws::ResourceGroups::GroupConfiguration;
  use Moose;
  has Configuration => (is => 'ro', isa => 'ArrayRef[Paws::ResourceGroups::GroupConfigurationItem]');
  has FailureReason => (is => 'ro', isa => 'Str');
  has ProposedConfiguration => (is => 'ro', isa => 'ArrayRef[Paws::ResourceGroups::GroupConfigurationItem]');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ResourceGroups::GroupConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ResourceGroups::GroupConfiguration object:

  $service_obj->Method(Att1 => { Configuration => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ResourceGroups::GroupConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Configuration

=head1 DESCRIPTION

A service configuration associated with a resource group. The
configuration options are determined by the AWS service that defines
the C<Type>, and specifies which resources can be included in the
group. You can add a service configuration when you create the group by
using CreateGroup, or later by using the PutGroupConfiguration
operation. For details about group service configuration syntax, see
Service configurations for resource groups
(https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).

=head1 ATTRIBUTES


=head2 Configuration => ArrayRef[L<Paws::ResourceGroups::GroupConfigurationItem>]

The configuration currently associated with the group and in effect.


=head2 FailureReason => Str

If present, the reason why a request to update the group configuration
failed.


=head2 ProposedConfiguration => ArrayRef[L<Paws::ResourceGroups::GroupConfigurationItem>]

If present, the new configuration that is in the process of being
applied to the group.


=head2 Status => Str

The current status of an attempt to update the group configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ResourceGroups>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

