use strict;
use warnings;

package App::Embra::MVP::Assembler;
$App::Embra::MVP::Assembler::VERSION = '0.001'; # TRIAL
# ABSTRACT: App::Embra-specific subclass of Config::MVP::Assembler

use App::Embra::Util;

use Moo;
extends 'Config::MVP::Assembler';
with 'Config::MVP::Assembler::WithBundles';


sub expand_package {
    my ( $self, $pkg_name ) = @_;
    App::Embra::Util->expand_config_package_name( $pkg_name );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::MVP::Assembler - App::Embra-specific subclass of Config::MVP::Assembler

=head1 VERSION

version 0.001

=head1 DESCRIPTION

App::Embra::MVP::Assembler extends L<Config::MVP::Assembler> and composes L<Config::MVP::Assembler::WithBundles> for potential plugin bundles (things composing L<App::Embra::Role::PluginBundle> (once that role is written)).

The Assembler's C<expand_package> method delegates to L<App::Embra::Util/expand_config_package_name>.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
