# Generated by default/object.tt
package Paws::Shield::EmergencyContact;
  use Moose;
  has ContactNotes => (is => 'ro', isa => 'Str');
  has EmailAddress => (is => 'ro', isa => 'Str', required => 1);
  has PhoneNumber => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Shield::EmergencyContact

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Shield::EmergencyContact object:

  $service_obj->Method(Att1 => { ContactNotes => $value, ..., PhoneNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Shield::EmergencyContact object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactNotes

=head1 DESCRIPTION

Contact information that the DRT can use to contact you if you have
proactive engagement enabled, for escalations to the DRT and to
initiate proactive customer support.

=head1 ATTRIBUTES


=head2 ContactNotes => Str

Additional notes regarding the contact.


=head2 B<REQUIRED> EmailAddress => Str

The email address for the contact.


=head2 PhoneNumber => Str

The phone number for the contact.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Shield>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

