#!/usr/bin/perl
# -*- mode: perl; coding: utf-8; tab-width: 4; -*-

use strict;
use lib qw(blib/lib blib/arch);
use Cv;

my $ARRAY = 0;					# 1: Cv:Mat, 0: Cv::Seq
$ARRAY = 1 if $0 =~ /-arr/;
$ARRAY = 0 if $0 =~ /-seq/;

Cv->NamedWindow("hull", 1);
my $img = Cv::Image->new([ 500, 500 ], CV_8UC3);
my $storage = Cv::MemStorage->new(0);

while (1) {
	my $count = int(rand(100) + 1);
	my $p;

	if (!$ARRAY) {
        $p = Cv::Seq::Point->new(&CV_SEQ_KIND_GENERIC | &CV_32SC2, $storage);
	} else {
        $p = Cv::Mat->new([1, $count], CV_32SC2);
	}

	foreach (0 .. $count - 1) {
		my $pt = [ map { rand($_ / 2) + $_ / 4 } @{$img->size} ];
		if (!$ARRAY) {
			$p->Push($pt);
		} else {
			$p->Set([0, $_], $pt);
		}
	}

	my $hull;
	if (!$ARRAY) {
		$hull = $p->ConvexHull2;
		bless $hull, 'Cv::Seq::Point';
	} else {
		$hull = Cv::Mat->new([ 1, $count ], CV_32SC1);
        $p->ConvexHull2($hull);
	}

	$img->Zero;
	foreach (0 .. $count - 1) {
		my $pt;
		if (!$ARRAY) {
			# $pt = $p->GetSeqElem($_);
			# $pt = $p->Get($_);
			$pt = $p->GetPoint($_);
		} else {
			$pt = $p->Get([0, $_]);
		}
		$img->Circle(
			$pt, 2, CV_RGB(255, 0, 0), CV_FILLED, CV_AA, 0,
			);
	}
	my @pts = map {
		if (!$ARRAY) {
			# $hull->GetSeqElem($_);
			# $hull->Get($_);
			$hull->GetPoint($_);
		} else {
			[ @{$p->Get(${$hull->Get([0, $_])}[0])}[0..1] ];
		}
	} (0 .. $hull->total - 1, 0);
	my $pt0 = shift(@pts);
	foreach my $pt (@pts) {
		$img->Line($pt0, $pt, CV_RGB(0, 255, 0), 1, CV_AA, 0);
		$pt0 = $pt;
	}
	$img->ShowImage("hull");

	my $key = Cv->WaitKey(0);
	$key &= 0x7f if $key >= 0;
	last if ($key == 27 || $key == ord('q') || $key == ord('Q')); # 'ESC'
}

exit 0;
