#---------------------------------------------------------------------
# $Header: /Perl/OlleDB/t/Helpers/assemblies.pl 10    08-08-17 22:32 Sommar $
#
# This is file that is C<require> by several test scripts to create
# two CLT types in the current database.
#
# $History: assemblies.pl $
# 
# *****************  Version 10  *****************
# User: Sommar       Date: 08-08-17   Time: 22:32
# Updated in $/Perl/OlleDB/t/Helpers
# Need to have a wait loop to drop assembly types, as SQL Server defers
# dropping of table parameters.
#
# *****************  Version 9  *****************
# User: Sommar       Date: 08-04-07   Time: 23:11
# Updated in $/Perl/OlleDB/t/Helpers
# Updated the UTF8StringMax assembly.
#
# *****************  Version 8  *****************
# User: Sommar       Date: 08-03-09   Time: 23:46
# Updated in $/Perl/OlleDB/t/Helpers
# Make it possible to only create some types for short execution time.
#
# *****************  Version 7  *****************
# User: Sommar       Date: 08-02-24   Time: 21:58
# Updated in $/Perl/OlleDB/t/Helpers
# Exclude temp tables from the cleanup, as that could be inaccessible
# table variables.
#
# *****************  Version 6  *****************
# User: Sommar       Date: 07-09-16   Time: 22:40
# Updated in $/Perl/OlleDB/t/Helpers
# Added a assembly with a large UDT.
#
# *****************  Version 5  *****************
# User: Sommar       Date: 05-10-29   Time: 22:08
# Updated in $/Perl/OlleDB/t/Helpers
#
# *****************  Version 4  *****************
# User: Sommar       Date: 05-07-25   Time: 0:42
# Updated in $/Perl/OlleDB/t/Helpers
# Added cleanup procedure.
#
# *****************  Version 3  *****************
# User: Sommar       Date: 05-07-20   Time: 22:42
# Updated in $/Perl/OlleDB/t/Helpers
#
# *****************  Version 2  *****************
# User: Sommar       Date: 05-07-17   Time: 18:04
# Updated in $/Perl/OlleDB/t/Helpers
#
# *****************  Version 1  *****************
# User: Sommar       Date: 05-07-16   Time: 17:14
# Created in $/Perl/OlleDB/t/Helpers
#---------------------------------------------------------------------

use strict;

sub delete_assembly{
    my($X, $assemblyname) = @_;

    $X->sql(<<SQLEND);
DECLARE \@assembly_id int,
        \@typename    sysname,
        \@list        nvarchar(MAX),
        \@i           int

SELECT \@assembly_id = assembly_id
FROM   sys.assemblies
WHERE  name = '$assemblyname'

IF \@assembly_id IS NOT NULL
BEGIN
   SELECT TOP 1 \@typename = name
   FROM   sys.assembly_types
   WHERE  assembly_id = \@assembly_id

   IF \@typename IS NOT NULL
   BEGIN
      SELECT \@i = 20

      WHILE \@i > 0
      BEGIN
         SELECT \@list = substring(tablelist, 1, datalength(tablelist)/2 - 1)
         FROM   (SELECT quotename(schema_name(o.schema_id)) + '.' +
                       quotename(o.name) + ',' AS [text()]
                 FROM   sys.objects o
                 WHERE  EXISTS (SELECT *
                                FROM  sys.columns c
                                JOIN  sys.types t  ON c.user_type_id = t.user_type_id
                                WHERE t.name = \@typename
                                  AND c.object_id = o.object_id)
                   AND  o.type = 'U'
                 FOR XML PATH('')) AS Dummy(tablelist)

         IF nullif(\@list, '') IS NULL
            BREAK

         -- There may be a table parameter lingering, that has not been
         IF \@list LIKE '%#[0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F][0-9A-F]%'
         BEGIN
            WAITFOR DELAY '00:00:01'
            SELECT \@i = \@i - 1
            CONTINUE
         END

         EXEC('DROP TABLE ' + \@list)
         BREAK
      END

      SELECT \@list = substring(proclist, 1, datalength(proclist)/2 - 1)
      FROM   (SELECT quotename(schema_name(o.schema_id)) + '.' +
                     quotename(o.name) + ',' AS [text()]
              FROM   sys.objects o
              WHERE  EXISTS (SELECT *
                             FROM  sys.parameters p
                             JOIN  sys.types t ON p.user_type_id = t.user_type_id
                             WHERE t.name = \@typename
                               AND p.object_id = o.object_id)
                AND  o.type = 'P'
              FOR XML PATH('')) AS Dummy(proclist)
      IF nullif(\@list, '') IS NOT NULL
         EXEC('DROP PROCEDURE ' + \@list)

      SELECT \@list = substring(funclist, 1, datalength(funclist)/2 - 1)
      FROM   (SELECT quotename(schema_name(o.schema_id)) + '.' +
                     quotename(o.name) + ',' AS [text()]
              FROM   sys.objects o
              WHERE  EXISTS (SELECT *
                             FROM  sys.parameters p
                             JOIN  sys.types t ON p.user_type_id = t.user_type_id
                             WHERE t.name = \@typename
                               AND p.object_id = o.object_id)
                AND  o.type = 'FN'
              FOR XML PATH('')) AS Dummy(funclist)
      IF nullif(\@list, '') IS NOT NULL
         EXEC('DROP FUNCTION ' + \@list)

      SELECT \@typename = quotename(\@typename)
      EXEC ('DROP TYPE ' + \@typename)
   END
   DROP ASSEMBLY $assemblyname
END
SQLEND
}

sub create_one_udt {
    my ($X, $typename, $assemblyname, $definition) = @_;
    delete_assembly($X, $assemblyname);
    return if not defined $typename;
$X->sql(<<SQLEND);
CREATE ASSEMBLY $assemblyname FROM $definition
CREATE TYPE [$typename] EXTERNAL NAME $assemblyname.[OlleDBtest.$assemblyname]
SQLEND
}

sub create_the_udts {
    my ($X, $cmplxname, $pointname, $stringname, $stringmaxname) = @_;

    my $sqlver = (split(/\./, $X->{SQL_version}))[0];
    my $save_binary = $X->{BinaryAsStr};
    $X->{BinaryAsStr} = 'x';

    create_one_udt($X, $cmplxname, 'OlleComplexInteger',
                   '0x4D5A90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000E1FBA0E00B409CD21B8014CCD21546869732070726F6772616D2063616E6E6F742062652072756E20696E20444F53206D6F64652E0D0D0A2400000000000000504500004C0103008C8252430000000000000000E0000E210B0108000012000000060000000000001E310000002000000040000000004000002000000002000004000000000000000400000000000000008000000002000000000000030000040000100000100000000010000010000000000000100000000000000000000000C43000005700000000400000C002000000000000000000000000000000000000006000000C00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000080000000000000000000000082000004800000000000000000000002E7465787400000024110000002000000012000000020000000000000000000000000000200000602E72737263000000C0020000004000000004000000140000000000000000000000000000400000402E72656C6F6300000C000000006000000002000000180000000000000000000000000000400000420000000000000000000000000000000000310000000000004800000002000500E0240000E40B000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000005E0002037D0300000402047D0400000402167D050000042A1330040019000000010000110002037D05000004020216250A7D04000004067D030000042A000000133002001F0000000200001100027B0500000416FE010B072D06730600000A7A027B030000040A2B00062A260002037D030000042A000000133002001F0000000200001100027B0500000416FE010B072D06730600000A7A027B040000040A2B00062A260002037D040000042A000000133003003A0000000300001100027B0500000416FE010B072D06730600000A7A027B03000004027B030000045A027B04000004027B040000045A586C280700000A0A2B00062A000013300200B6000000040000110003750200000214FE030C082D07150B389F00000003A5020000020A027B050000042C0C12007B0500000416FE012B01170C082D04160B2B7B027B050000042D0C12007B0500000416FE012B01160C082D04150B2B5E027B0300000412007B030000043314027B0400000412007B04000004FE0116FE012B01170C082D04160B2B3202280700000612002807000006FE0116FE010C082D04150B2B180228070000060D120312002807000006280800000A0B2B00072A0000133002001000000005000011000203280800000616FE010A2B00062A133001001400000006000011000228070000060B1201280900000A0A2B00062A133002001E00000007000011000F00038C02000002FE16020000026F0A00000A280B00000A0A2B00062A0000133002002100000007000011000F00038C02000002FE16020000026F0A00000A16FE01280B00000A0A2B00062A000000133002001B00000007000011000F00038C02000002280800000616FE04280B00000A0A2B00062A00133002001B00000007000011000F00038C02000002280800000616FE02280B00000A0A2B00062A00133003003C000000080000110012001628020000060012000F007B030000040F017B03000004587D0300000412000F007B040000040F017B04000004587D04000004060B2B00072A133003003C000000080000110012001628020000060012000F007B030000040F017B03000004597D0300000412000F007B040000040F017B04000004597D04000004060B2B00072A13300400600000000900001100027B050000042D4D1B8D120000010B07167201000070A20717027C03000004280C00000A280D00000AA207187205000070A20719027C04000004280C00000A280D00000AA2071A7209000070A207280E00000A2B05720F0000700A2B00062A133001000C0000000500001100027B050000040A2B00062A13300300920000000A000011000F00FE16060000016F0F00000A0A0F00281000000A16FE010D092D091773020000060C2B6A7E02000004066F1100000A0B076F1200000A0D092D167231000070067279000070281300000A731400000A7A076F1500000A176F1600000A6F1700000A280C00000A281800000A076F1500000A186F1600000A6F1700000A280C00000A281800000A73010000060C2B00082A0000133001000B0000000B000011007E060000040A2B00062A7672F90000701F0C731900000A800200000417730200000680060000042A00000042534A4201000100000000000C00000076322E302E35303732370000000005006C00000050040000237E0000BC0400002C04000023537472696E677300000000E808000074010000235553005C0A00001000000023475549440000006C0A00007801000023426C6F620000000000000002000001571FA2010900000000FA013300160000010000001B00000002000000060000001500000014000000020000001900000001000000030000000B000000010000000500000007000000010000000300000000000A0001000000000006004B0044000A00760061000600800044000E00B00091000A00420161000A00B101610006000D02ED0106002D02ED0106005A0244000A008B0270020A00A70270020600CD02AE020600E302AE0206000403440006002403440006003203440006003F03440006005203440006006E03590306008F0344000600950344000E00B60391000E00BC0391000600CE0344000E00E00391000E00040491000E001D0491000000000001000000000001000100092110001D00300005000100010051808C000A003100B6002E000100BE0032000100C40032000100CF0035003100D70038005020000000008618E5003C0001006820000000008118E500420003009020000000008608EB0047000400BB20000000008608F4004B000400C820000000008608FD0047000500F3200000000086080B014B0005000021000000008608190150000600482100000000E6012501540006000C2200000000C6002F0159000700282200000000C60036014700080048220000000096084D015E000800742200000000960859015E000A00A42200000000960867015E000C00CC2200000000960873015E000E00F4220000000096088201670010003C230000000096088E0167001200842300000000C6009D0170001400F02300000000E609A601740014000824000000009600BB0178001400A824000000009608C1017F001500BF2400000000911816044301150000000100EE0200000200F30200000100FD02000001001E03000001001E03000001002E03000001002E03000001003903000002003C03000001003903000002003C03000001003903000002003C03000001003903000002003C03000001003903000002003C03000001003903000002003C0300000100AC030200090002000D003900E5004B004100E50095004900E50095005100E50099006100E500B9007100E500950079002903C80081002501D20081003601470089002F01590029004603E80099007A03FA00A1009D01FF009100A503050189009D0170003100A60174002100B6031101B900C20374009100A5031701C100E5001E01B100F0032301C900FB032801D1000C047000A100BB012E012100E50047010E0004000D002E000B004E012E0013005701430023009F00BF00C300CD00D700DF00E300EE00F3000B0135013E01020001000000CA0184000000CF0184000000D90188000000E1018C000000E8019000020003000300010004000300010006000500020005000500020007000700020012000900020014000B000480000000000000000000000000000000004B02000002000000000000000000000001003B00000000000200000000000000000000000100550000000000020000000000000000000000010044000000000000000000003C4D6F64756C653E00636F6D706C6578696E74656765722E646C6C004F6C6C65436F6D706C6578496E7465676572004F6C6C65444274657374006D73636F726C69620053797374656D0056616C7565547970650053797374656D2E446174610053797374656D2E446174612E53716C547970657300494E756C6C61626C650049436F6D70617261626C65004E554C4C0053797374656D2E546578742E526567756C617245787072657373696F6E73005265676578005F706172736572005F7265616C005F696D6167696E617279005F69736E756C6C004E554C4C5F494E5354414E4345002E63746F72006765745F5265616C007365745F5265616C006765745F496D6167696E617279007365745F496D6167696E617279006765745F4D6F64756C757300436F6D70617265546F00457175616C730047657448617368436F64650053716C426F6F6C65616E006F705F457175616C697479006F705F496E657175616C697479006F705F4C6573735468616E006F705F477265617465725468616E006F705F4164646974696F6E006F705F5375627472616374696F6E00546F537472696E67006765745F49734E756C6C0053716C537472696E67005061727365006765745F4E756C6C005265616C00496D6167696E617279004D6F64756C75730049734E756C6C004E756C6C0053797374656D2E52756E74696D652E436F6D70696C6572536572766963657300436F6D70696C6174696F6E52656C61786174696F6E734174747269627574650052756E74696D65436F6D7061746962696C69747941747472696275746500636F6D706C6578696E74656765720053657269616C697A61626C65417474726962757465004D6963726F736F66742E53716C5365727665722E5365727665720053716C55736572446566696E65645479706541747472696275746500466F726D61740053797374656D2E52756E74696D652E496E7465726F705365727669636573005374727563744C61796F7574417474726962757465004C61796F75744B696E64007265616C00696D6167696E6172790069736E756C6C00496E76616C69644F7065726174696F6E457863657074696F6E0076616C7565004D6174680053717274006F626A00446F75626C65006331006332004F626A656374006F705F496D706C6963697400537472696E670053797374656D2E476C6F62616C697A6174696F6E0043756C74757265496E666F006765745F496E76617269616E7443756C7475726500496E7433320049466F726D617450726F766964657200436F6E6361740073716C537472696E67004D617463680047726F7570006765745F5375636365737300417267756D656E74457863657074696F6E0047726F7570436F6C6C656374696F6E006765745F47726F757073006765745F4974656D0043617074757265006765745F56616C7565002E6363746F720052656765784F7074696F6E730000000003280000032C0000056900290000213C003C006E0075006C006C00200063006F006D0070006C00650078003E003E00004749006E00760061006C0069006400200066006F0072006D0061007400200066006F007200200063006F006D0070006C006500780020006E0075006D0062006500720020002700017F27002E00200046006F0072006D00610074002000690073002000280020006E002C0020006D0069002000290020007700680065007200650020006E00200061006E00640020006D002000610072006500200066006C006F006100740069006E006700200070006F0069006E00740020006E0075006D00620065007200730001795C0041005C0028005C0073002A0028003F003C007200650061006C003E005C002D003F005C0064002B0029005C0073002A002C005C0073002A0028003F003C0069006D0067003E005C002D003F005C0064002B0028005C002E005C0064002B0029003F0029005C0073002A0069005C0073002A005C00290001000BB4864BF4D4A042895EFABB169D699E0008B77A5C561934E08902060E203C003C006E0075006C006C00200063006F006D0070006C00650078003E003E00030612110206080206020306110805200201080804200101020320000804200101080320000D042001081C042001021C0800021115110811080800021108110811080320000E03200002060001110811190400001108032800080328000D0328000204080011080320000105200101112D19010001000000010054020D4973427974654F726465726564010520010111350307010804070208020400010D0D0407020D02042001080D070704110808020D03070102040702080D050001111502040701111506070211081108040000124D0520010E12550500010E1D0E0507020E1D0E05200112590E0600030E0E0E0E042001010E0420001265052001125D08060002080E12550807040E1259110802040701110803000001062002010E116D0801000800000000001E01000100540216577261704E6F6E457863657074696F6E5468726F7773010000EC30000000000000000000000E310000002000000000000000000000000000000000000000000000003100000000000000000000000000000000000000005F436F72446C6C4D61696E006D73636F7265652E646C6C0000000000FF25002040000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000001800008000000000000000000000000000000100010000003000008000000000000000000000000000000100000000004800000058400000640200000000000000000000640234000000560053005F00560045005200530049004F004E005F0049004E0046004F0000000000BD04EFFE00000100000000000000000000000000000000003F000000000000000400000002000000000000000000000000000000440000000100560061007200460069006C00650049006E0066006F00000000002400040000005400720061006E0073006C006100740069006F006E00000000000000B004C4010000010053007400720069006E006700460069006C00650049006E0066006F000000A001000001003000300030003000300034006200300000002C0002000100460069006C0065004400650073006300720069007000740069006F006E000000000020000000300008000100460069006C006500560065007200730069006F006E000000000030002E0030002E0030002E003000000048001300010049006E007400650072006E0061006C004E0061006D006500000063006F006D0070006C006500780069006E00740065006700650072002E0064006C006C00000000002800020001004C006500670061006C0043006F0070007900720069006700680074000000200000005000130001004F0072006900670069006E0061006C00460069006C0065006E0061006D006500000063006F006D0070006C006500780069006E00740065006700650072002E0064006C006C0000000000340008000100500072006F006400750063007400560065007200730069006F006E00000030002E0030002E0030002E003000000038000800010041007300730065006D0062006C0079002000560065007200730069006F006E00000030002E0030002E0030002E0030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000003000000C000000203100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
    create_one_udt($X, $pointname, 'OllePoint',
                   '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
    create_one_udt($X, $stringname, 'OlleString',
                   '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

    if ($sqlver >= 10) {
       create_one_udt($X, $stringmaxname, 'OlleStringMax',
                      '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');
    }

    $X->{BinaryAsStr} = $save_binary;

}

sub delete_the_udts {
   my ($X) = @_;

   delete_assembly($X, 'OlleComplexInteger');
   delete_assembly($X, 'OllePoint');
   delete_assembly($X, 'OlleString');
   delete_assembly($X, 'OlleStringMax');
}

1;
