; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
;
; template vars:
;
; %app_name%
; %app_version%
; %app_exe% - name of the main executable
; %author%
; %author_url%
; %support_url%
; %updates_url%
;
; %base_dir% - where the original files are located
;
; ToDo:
; - check for installed Perl
; - install perl modules

[Setup]
AppName=%app_name%
AppVersion=%app_version%
AppVerName=%app_name% %app_version%
AppPublisher=%author%
AppPublisherURL=%author_url%
AppSupportURL=%support_url%
AppUpdatesURL=%updates_url%
; VersionInfoCompany = AppPublisher
; VersionInfoDescription= "AppName Setup"
; VersionInfoTextVersion = VersionInfoVersion
VersionInfoVersion=%app_version%
DefaultDirName={pf}\%app_name%
DefaultGroupName=%app_name%
AllowNoIcons=yes
LicenseFile=%base_dir%\LICENSE
InfoBeforeFile=%base_dir%\INSTALL
InfoAfterFile=%base_dir%\README
AppReadmeFile=%base_dir%\README
Compression=lzma
SolidCompression=yes
OutputBaseFilename=%app_name%-%app_version%
OutputDir=.

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: perlmodules; Description: {cm:InstallPerlModules}; GroupDescription: {cm:Perl}; Flags: unchecked

[Files]
Source: %base_dir%\*; DestDir: {app}; Flags: ignoreversion recursesubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[INI]
Filename: {app}\%app_name%.url; Section: InternetShortcut; Key: URL; String: %support_url%

[Icons]
Name: {group}\%app_name%; Filename: {app}\%app_exe%; WorkingDir: {app}\bin
Name: {group}\{cm:ProgramOnTheWeb,%app_name%}; Filename: {app}\%app_name%.url
Name: {group}\{cm:InstallPerlModules}; Filename: {app}\install.bat; Parameters: {reg:HKLM\SOFTWARE\ActiveState\ActivePerl\{reg:HKLM\SOFTWARE\ActiveState\ActivePerl,CurrentVersion|00},|}; WorkingDir: {app}
Name: {group}\{cm:UninstallProgram,%app_name%}; Filename: {uninstallexe}
Name: {userdesktop}\%app_name%; Filename: {app}\%app_exe%; Tasks: desktopicon; WorkingDir: {app}\bin
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\%app_name%; Filename: {app}\%app_exe%; Tasks: quicklaunchicon; WorkingDir: {app}\bin

[Run]
Filename: {app}\install.bat; Description: {cm:InstallPerlModules}; StatusMsg: {cm:InstallingPerlModules}; Flags: shellexec; Parameters: {reg:HKLM\SOFTWARE\ActiveState\ActivePerl\{reg:HKLM\SOFTWARE\ActiveState\ActivePerl,CurrentVersion|00},|}; Tasks: perlmodules
Filename: {app}\%app_exe%; Description: {cm:LaunchProgram,%app_name%}; Flags: shellexec postinstall skipifsilent

[UninstallDelete]
Type: files; Name: {app}\%app_name%.url
Type: files; Name: {app}\Build
Type: files; Name: {app}\pod2htmli.x~~
Type: files; Name: {app}\pod2htmld.x~~
Name: t; Type: filesandordirs
Name: _build; Type: filesandordirs
Name: blib; Type: filesandordirs


[CustomMessages]
InstallPerlModules=Install %app_name% perl modules (not required to run PBib)
InstallingPerlModules=Installing %app_name% Perl modules ...
Perl=Perl
