use v6;

#
# This program creates metrics modules for some fonts and place them
# under the "Metrics" directory.
#
# Author: Gisle Aas
# Perl 5 -> 6 Port: David Warring

BEGIN %*ENV<METRICS> //= 'etc/Core14_AFMs';

use lib 'lib';
use Font::AFM;

class Build {

    method !build-metrics {

        BEGIN our @CoreFonts = <
            Courier      Courier-Bold     Courier-Oblique    Courier-BoldOblique
            Helvetica    Helvetica-Bold   Helvetica-Oblique  Helvetica-BoldOblique
            Times-Roman  Times-Bold       Times-Italic       Times-BoldItalic
            Symbol       ZapfDingbats
        >;

        for @CoreFonts -> $font-name {
            my Str $class-name = Font::AFM.class-name( $font-name );
            my Str @parts = $class-name.split('::');
            my Str $mod-name = @parts.pop;
            my $lib-dir = $*SPEC.catdir('lib', @parts);
            mkdir( $lib-dir, 0o755)
                unless $lib-dir.IO ~~ :e;

            my $afm = Font::AFM.new: $font-name;

            say "Building $font-name => $class-name";
            {
                my $gen-path = $*SPEC.catfile($lib-dir, "$mod-name.pm");
                my $*OUT = open( $gen-path, :w);

                my Hash $metrics = %( $afm ).item;

                print q:s:c:to"--CODE-GEN--";
                use v6;
                # Font metrics for $font-name
                #
                # DO NOT EDIT!!!
                #
                # This file was auto-generated by {$*SPEC.abs2rel($?FILE)} based on the AFM file for the font.
                #
                # {$afm.Notice}

                use Font::AFM;

                --CODE-GEN--

                say "class $class-name";
                say '    is Font::AFM {';

                say "    BEGIN our \$metrics = {$metrics.perl}";
                say '';
                say '    method new { self.bless( :$metrics ) }';
                say '}';
            }
        }
    }

    method build($where) {

        indir $where, {
            self!"build-metrics"();
        }
    }
}

# Build.pm can also be run standalone 
sub MAIN(:$indir = '.', :$metrics-path?, :$glyphs-path ) {

    %*ENV<METRICS> = $metrics-path
        if $metrics-path.defined;

    Build.new.build($indir);
}
