package CGI::Test::Page::Other;
use strict;
####################################################################
# $Id: Other.pm,v 1.2 2003/09/29 11:00:49 mshiltonj Exp $
# $Name: cgi-test_0-104_t1 $
####################################################################
#
#  Copyright (c) 2001, Raphael Manfredi
#
#  You may redistribute only under the terms of the Artistic License,
#  as specified in the README file that comes with the distribution.
#

use Carp::Datum;
use Getargs::Long;

require CGI::Test::Page::Real;
use base qw(CGI::Test::Page::Real);

#
# ->new
#
# Creation routine
#
sub new
{
    DFEATURE my $f_;
    my $this = bless {}, shift;
    $this->_init(@_);
    return DVAL $this;
}

1;

=head1 NAME

CGI::Test::Page::Other - A real page, but neither text nor HTML

=head1 SYNOPSIS

 # Inherits from CGI::Test::Page::Real

=head1 DESCRIPTION

This class represents an HTTP reply containing neither C<text/hmtl>
nor C<text/plain> data.
Its interface is the same as the one described in L<CGI::Test::Page::Real>.

=head1 WEBSITE

You can find information about CGI::Test and other related modules at:

   http://cgi-test.sourceforge.net

=head1 PUBLIC CVS SERVER

CGI::Test now has a publicly accessible CVS server provided by
SourceForge (www.sourceforge.net).  You can access it by going to:

    http://sourceforge.net/cvs/?group_id=89570

=head1 AUTHORS

The original author is Raphael Manfredi F<E<lt>Raphael_Manfredi@pobox.comE<gt>>. 

Send bug reports, hints, tips, suggestions to Steven Hilton at <mshiltonj@mshiltonj.com>

=head1 SEE ALSO

CGI::Test::Page::Real(3).

=cut

