=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::HandoutLayoutingOptions;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::SlidesLayoutOptions;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Handout layouting options
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	$self->{ layout_type } = 'Handout';
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Handout layouting options',
                                  class => 'HandoutLayoutingOptions',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'layout_type' => {
    	datatype => 'string',
    	base_name => 'LayoutType',
    	description => '',
    	format => '',
    	read_only => '',
    		},
    'handout' => {
    	datatype => 'string',
    	base_name => 'Handout',
    	description => 'Specified how many pages and in what sequence will be placed on the page.',
    	format => '',
    	read_only => '',
    		},
    'print_slide_numbers' => {
    	datatype => 'boolean',
    	base_name => 'PrintSlideNumbers',
    	description => 'True to print the displayed slide numbers.',
    	format => '',
    	read_only => '',
    		},
    'print_comments' => {
    	datatype => 'boolean',
    	base_name => 'PrintComments',
    	description => 'True to display comments on slide.',
    	format => '',
    	read_only => '',
    		},
    'print_frame_slide' => {
    	datatype => 'boolean',
    	base_name => 'PrintFrameSlide',
    	description => 'True to draw frames around the displayed slides.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'layout_type' => 'string',
    'handout' => 'string',
    'print_slide_numbers' => 'boolean',
    'print_comments' => 'boolean',
    'print_frame_slide' => 'boolean'
} );

__PACKAGE__->attribute_map( {
    'layout_type' => 'LayoutType',
    'handout' => 'Handout',
    'print_slide_numbers' => 'PrintSlideNumbers',
    'print_comments' => 'PrintComments',
    'print_frame_slide' => 'PrintFrameSlide'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
