=begin comment

Copyright (c) 2019 Aspose Pty Ltd

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

=end comment

=cut

package AsposeSlidesCloud::Object::Portion;

require 5.6.0;
use strict;
use warnings;
use utf8;
use JSON qw(decode_json);
use Data::Dumper;
use Module::Runtime qw(use_module);
use Log::Any qw($log);
use Date::Parse;
use DateTime;

use AsposeSlidesCloud::Object::EffectFormat;
use AsposeSlidesCloud::Object::FillFormat;
use AsposeSlidesCloud::Object::Hyperlink;
use AsposeSlidesCloud::Object::LineFormat;
use AsposeSlidesCloud::Object::MathParagraph;
use AsposeSlidesCloud::Object::ResourceBase;
use AsposeSlidesCloud::Object::ResourceUri;

use base ("Class::Accessor", "Class::Data::Inheritable");


#
#Represents portion resource
#
# NOTE: This class is auto generated by the swagger code generator program. Do not edit the class manually.
# REF: https://github.com/swagger-api/swagger-codegen
#

#
# NOTE: This class is auto generated by the swagger code generator program. 
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
__PACKAGE__->mk_classdata('attribute_map' => {});
__PACKAGE__->mk_classdata('swagger_types' => {});
__PACKAGE__->mk_classdata('method_documentation' => {}); 
__PACKAGE__->mk_classdata('class_documentation' => {});

# new object
sub new { 
    my ($class, %args) = @_; 

	my $self = bless {}, $class;
	
	foreach my $attribute (keys %{$class->attribute_map}) {
		my $args_key = $class->attribute_map->{$attribute};
		$self->$attribute( $args{ $args_key } );
	}
	return $self;
}  

# used by JSON for serialization
sub TO_JSON { 
    my $self = shift;
    my $_data = {};
    foreach my $_key (keys %{$self->attribute_map}) {
        if (defined $self->{$_key}) {
            $_data->{$self->attribute_map->{$_key}} = $self->{$_key};
        }
    }
    return $_data;
}


__PACKAGE__->class_documentation({description => 'Represents portion resource',
                                  class => 'Portion',
                                  required => [], # TODO
}                                 );

__PACKAGE__->method_documentation({
    'self_uri' => {
    	datatype => 'ResourceUri',
    	base_name => 'SelfUri',
    	description => 'Gets or sets the link to this resource.',
    	format => '',
    	read_only => '',
    		},
    'alternate_links' => {
    	datatype => 'ARRAY[ResourceUri]',
    	base_name => 'AlternateLinks',
    	description => 'List of alternate links.',
    	format => '',
    	read_only => '',
    		},
    'text' => {
    	datatype => 'string',
    	base_name => 'Text',
    	description => 'Text.',
    	format => '',
    	read_only => '',
    		},
    'math_paragraph' => {
    	datatype => 'MathParagraph',
    	base_name => 'MathParagraph',
    	description => 'Math paragraph.',
    	format => '',
    	read_only => '',
    		},
    'font_bold' => {
    	datatype => 'string',
    	base_name => 'FontBold',
    	description => 'True for bold font.',
    	format => '',
    	read_only => '',
    		},
    'font_italic' => {
    	datatype => 'string',
    	base_name => 'FontItalic',
    	description => 'True for italic font.',
    	format => '',
    	read_only => '',
    		},
    'font_underline' => {
    	datatype => 'string',
    	base_name => 'FontUnderline',
    	description => 'Text underline type.',
    	format => '',
    	read_only => '',
    		},
    'strikethrough_type' => {
    	datatype => 'string',
    	base_name => 'StrikethroughType',
    	description => 'Text strikethrough type.',
    	format => '',
    	read_only => '',
    		},
    'text_cap_type' => {
    	datatype => 'string',
    	base_name => 'TextCapType',
    	description => 'Text capitalization type.',
    	format => '',
    	read_only => '',
    		},
    'escapement' => {
    	datatype => 'double',
    	base_name => 'Escapement',
    	description => 'Superscript or subscript of the text.',
    	format => '',
    	read_only => '',
    		},
    'spacing' => {
    	datatype => 'double',
    	base_name => 'Spacing',
    	description => 'Intercharacter spacing increment.',
    	format => '',
    	read_only => '',
    		},
    'font_color' => {
    	datatype => 'string',
    	base_name => 'FontColor',
    	description => 'Font color.',
    	format => '',
    	read_only => '',
    		},
    'highlight_color' => {
    	datatype => 'string',
    	base_name => 'HighlightColor',
    	description => 'Highlight color.',
    	format => '',
    	read_only => '',
    		},
    'font_height' => {
    	datatype => 'double',
    	base_name => 'FontHeight',
    	description => 'Font height.',
    	format => '',
    	read_only => '',
    		},
    'normalise_height' => {
    	datatype => 'string',
    	base_name => 'NormaliseHeight',
    	description => 'True to normalize the text.',
    	format => '',
    	read_only => '',
    		},
    'proof_disabled' => {
    	datatype => 'string',
    	base_name => 'ProofDisabled',
    	description => 'True if the text proof should be disabled.',
    	format => '',
    	read_only => '',
    		},
    'smart_tag_clean' => {
    	datatype => 'boolean',
    	base_name => 'SmartTagClean',
    	description => 'True if smart tag should be cleaned.',
    	format => '',
    	read_only => '',
    		},
    'kerning_minimal_size' => {
    	datatype => 'double',
    	base_name => 'KerningMinimalSize',
    	description => 'Minimal font size for kerning.',
    	format => '',
    	read_only => '',
    		},
    'kumimoji' => {
    	datatype => 'string',
    	base_name => 'Kumimoji',
    	description => 'True if numbers should ignore East-Asian specific vertical text layout.',
    	format => '',
    	read_only => '',
    		},
    'language_id' => {
    	datatype => 'string',
    	base_name => 'LanguageId',
    	description => 'Proving language ID.',
    	format => '',
    	read_only => '',
    		},
    'alternative_language_id' => {
    	datatype => 'string',
    	base_name => 'AlternativeLanguageId',
    	description => 'Alternative proving language ID.',
    	format => '',
    	read_only => '',
    		},
    'is_hard_underline_fill' => {
    	datatype => 'string',
    	base_name => 'IsHardUnderlineFill',
    	description => 'True if underline style has own FillFormat properties.',
    	format => '',
    	read_only => '',
    		},
    'is_hard_underline_line' => {
    	datatype => 'string',
    	base_name => 'IsHardUnderlineLine',
    	description => 'True if underline style has own LineFormat properties.',
    	format => '',
    	read_only => '',
    		},
    'fill_format' => {
    	datatype => 'FillFormat',
    	base_name => 'FillFormat',
    	description => 'Fill format.',
    	format => '',
    	read_only => '',
    		},
    'effect_format' => {
    	datatype => 'EffectFormat',
    	base_name => 'EffectFormat',
    	description => 'Effect format.',
    	format => '',
    	read_only => '',
    		},
    'line_format' => {
    	datatype => 'LineFormat',
    	base_name => 'LineFormat',
    	description => 'Line format.',
    	format => '',
    	read_only => '',
    		},
    'underline_fill_format' => {
    	datatype => 'FillFormat',
    	base_name => 'UnderlineFillFormat',
    	description => 'Underline fill format.',
    	format => '',
    	read_only => '',
    		},
    'underline_line_format' => {
    	datatype => 'LineFormat',
    	base_name => 'UnderlineLineFormat',
    	description => 'Underline line format.',
    	format => '',
    	read_only => '',
    		},
    'hyperlink_click' => {
    	datatype => 'Hyperlink',
    	base_name => 'HyperlinkClick',
    	description => 'Hyperlink defined for mouse click.',
    	format => '',
    	read_only => '',
    		},
    'hyperlink_mouse_over' => {
    	datatype => 'Hyperlink',
    	base_name => 'HyperlinkMouseOver',
    	description => 'Hyperlink defined for mouse over.',
    	format => '',
    	read_only => '',
    		},
    'latin_font' => {
    	datatype => 'string',
    	base_name => 'LatinFont',
    	description => 'Returns or sets the Latin font info.',
    	format => '',
    	read_only => '',
    		},
    'east_asian_font' => {
    	datatype => 'string',
    	base_name => 'EastAsianFont',
    	description => 'Returns or sets the East Asian font info.',
    	format => '',
    	read_only => '',
    		},
    'complex_script_font' => {
    	datatype => 'string',
    	base_name => 'ComplexScriptFont',
    	description => 'Returns or sets the complex script font info.',
    	format => '',
    	read_only => '',
    		},
});

__PACKAGE__->swagger_types( {
    'self_uri' => 'ResourceUri',
    'alternate_links' => 'ARRAY[ResourceUri]',
    'text' => 'string',
    'math_paragraph' => 'MathParagraph',
    'font_bold' => 'string',
    'font_italic' => 'string',
    'font_underline' => 'string',
    'strikethrough_type' => 'string',
    'text_cap_type' => 'string',
    'escapement' => 'double',
    'spacing' => 'double',
    'font_color' => 'string',
    'highlight_color' => 'string',
    'font_height' => 'double',
    'normalise_height' => 'string',
    'proof_disabled' => 'string',
    'smart_tag_clean' => 'boolean',
    'kerning_minimal_size' => 'double',
    'kumimoji' => 'string',
    'language_id' => 'string',
    'alternative_language_id' => 'string',
    'is_hard_underline_fill' => 'string',
    'is_hard_underline_line' => 'string',
    'fill_format' => 'FillFormat',
    'effect_format' => 'EffectFormat',
    'line_format' => 'LineFormat',
    'underline_fill_format' => 'FillFormat',
    'underline_line_format' => 'LineFormat',
    'hyperlink_click' => 'Hyperlink',
    'hyperlink_mouse_over' => 'Hyperlink',
    'latin_font' => 'string',
    'east_asian_font' => 'string',
    'complex_script_font' => 'string'
} );

__PACKAGE__->attribute_map( {
    'self_uri' => 'SelfUri',
    'alternate_links' => 'AlternateLinks',
    'text' => 'Text',
    'math_paragraph' => 'MathParagraph',
    'font_bold' => 'FontBold',
    'font_italic' => 'FontItalic',
    'font_underline' => 'FontUnderline',
    'strikethrough_type' => 'StrikethroughType',
    'text_cap_type' => 'TextCapType',
    'escapement' => 'Escapement',
    'spacing' => 'Spacing',
    'font_color' => 'FontColor',
    'highlight_color' => 'HighlightColor',
    'font_height' => 'FontHeight',
    'normalise_height' => 'NormaliseHeight',
    'proof_disabled' => 'ProofDisabled',
    'smart_tag_clean' => 'SmartTagClean',
    'kerning_minimal_size' => 'KerningMinimalSize',
    'kumimoji' => 'Kumimoji',
    'language_id' => 'LanguageId',
    'alternative_language_id' => 'AlternativeLanguageId',
    'is_hard_underline_fill' => 'IsHardUnderlineFill',
    'is_hard_underline_line' => 'IsHardUnderlineLine',
    'fill_format' => 'FillFormat',
    'effect_format' => 'EffectFormat',
    'line_format' => 'LineFormat',
    'underline_fill_format' => 'UnderlineFillFormat',
    'underline_line_format' => 'UnderlineLineFormat',
    'hyperlink_click' => 'HyperlinkClick',
    'hyperlink_mouse_over' => 'HyperlinkMouseOver',
    'latin_font' => 'LatinFont',
    'east_asian_font' => 'EastAsianFont',
    'complex_script_font' => 'ComplexScriptFont'
} );

__PACKAGE__->mk_accessors(keys %{__PACKAGE__->attribute_map});


1;
