(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Wed Nov 25 02:21:32 PST 1992 by mhb *)

(* This interface used by widgets in VBTKit to retrieve their
   resources.  Resources are look for using the path consisting
   of the value of the environment variable VBTKITPATH followed
   by the bundle VBTKitBundle. *)

INTERFACE VBTKitResources;

IMPORT Pixmap;

PROCEDURE Get (name: TEXT): TEXT;
(* Return the contents of the resource "name".  It is a runtime
   exception if "name" cannot be read successfully. *)

PROCEDURE GetPixmap (name: TEXT): Pixmap.T;
(* Return the bitmap "name" as a scaled pixmap.  It is a runtime
   exception if "name" is not found or if it cannot be read
   successfully using XBitmap.ReadRaw.  (In the glorious future,
   this procedure should be able to read pixmaps in "ppm(5)"
   format.) *)

END VBTKitResources.

