(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jun 11 16:07:37 PDT 1993 by meehan     *)
(*      modified on Sun Jan 31 20:54:42 PST 1993 by mhb        *)
(*      modified on Tue Jun 16 13:08:31 PDT 1992 by muller     *)
<*PRAGMA LL*>

(* A "PixmapVBT.T" is a VBT that displays a pixmap. Its preferred
   and minimum sizes are the size of the pixmap, and its maximum size
   in each axis is very large. *)

INTERFACE PixmapVBT;

IMPORT VBT, PaintOp, Pixmap;

TYPE
  T <: Public;
  Public =
    VBT.Leaf OBJECT
    METHODS
      <* LL.sup <= VBT.mu *>
      init (pm: Pixmap.T; 
            op: PaintOp.T := PaintOp.BgFg;
            bg: PaintOp.T := PaintOp.Bg): T
    END;

(* The call "v.init(...)" initializes "v" as a "PixmapVBT" displaying
   pixmap "pm" using the paint op "op", and returns "v".  The pixmap
   is always centered within the domain of "v", and if the domain is
   larger than the pixmap, the background is painted using the tint
   "bg".

   When the pixmap has depth 1, "op" should be a pair of tints.
   Otherwise, a good choice for "op" is "PaintOp.Copy". *)

PROCEDURE Put (v: T; pm: Pixmap.T);
<* LL.sup = VBT.mu *>
(* Change the pixmap displayed by "v" to "pm", and mark "v" for redisplay. *)

PROCEDURE SetColors (v : T;
                     op: PaintOp.T;
                     bg: PaintOp.T   := PaintOp.Bg);
<* LL.sup = VBT.mu *>
(* Change the "op" and "bg" of "v", and mark "v" for redisplay. *)

END PixmapVBT.


