(* Copyright (C) 1995, Digital Equipment Corporation                         *)
(* Digital Internal Use Only                                                 *)
(* All rights reserved.                                                      *)
(*                                                                           *)
(* Last modified on Wed Jan 18 23:56:20 PST 1995 by najork                   *)
(*       Created on Wed Jan 18 21:06:32 PST 1995 by najork                   *)

UNSAFE MODULE Address;

IMPORT Integer, Word;

PROCEDURE Equal(a, b: T): BOOLEAN =
  BEGIN
    RETURN a = b;
  END Equal;


PROCEDURE Hash(a: T): Word.T =
  BEGIN
    RETURN LOOPHOLE(a, Word.T);
  END Hash;


PROCEDURE Compare(a, b: T): [-1..1] =
  BEGIN
    RETURN Integer.Compare(LOOPHOLE(a, INTEGER), LOOPHOLE(b, INTEGER));
  END Compare;


BEGIN
END Address.
