(* Copyright 1991 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)

INTERFACE ObLibUI;
IMPORT SynLocation, ObValue, Color, FormsVBT;

  PROCEDURE PackageSetup();
  (* To be called at least once before any other use of the obliqlibui package. *)

  TYPE 
    ValColor =
      ObValue.ValAnything BRANDED OBJECT
        color: Color.T;
      OVERRIDES Is := IsColor; Copy := CopyColor;
      END;

  PROCEDURE IsColor(self: ValColor; other: ObValue.ValAnything): BOOLEAN;
  PROCEDURE CopyColor(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error};

  TYPE 
    ValForm =
      ObValue.ValAnything BRANDED OBJECT
        form: FormsVBT.T;
      OVERRIDES Is := IsForm; Copy := CopyForm;
      END;

  PROCEDURE IsForm(self: ValForm; other: ObValue.ValAnything): BOOLEAN;
  PROCEDURE CopyForm(self: ObValue.ValAnything; tbl: ObValue.Tbl;
    loc: SynLocation.T): ObValue.ValAnything RAISES {ObValue.Error};
    (* Raises Error *)

END ObLibUI.
