#include <stdio.h>  /* Pike thinks this is wrong */
#include <stdlib.h>
#include <string.h>
#define NULL 0
#define K 1024
#define M K*K
#define MAXFDS   64 /* Maximum number of file descriptors */

#define streq(s1, s2) (strcmp(s1, s2) == 0)
/* these are not in standard places so we declare them explicitly */
extern void bzero(void *b1, int length);
extern void bcopy(const void *src, void *dst, int length);
extern int bcmp(const void *b1, const void *b2, int length);
extern int getw(FILE *);
/* syscalls not defined elsewhere */
extern int close(int);

/* Type of a memory address. */
typedef unsigned long mem_addr;
#define BYTES_PER_WORD 4	/* On the MIPS processor */

/* Sizes of memory segments.
 *
 *  This is not necessary.
 *   ALL OF THIS MUST GO 
 */
#ifndef TEXT_SIZE   /* Initial size of text segment. */
#define TEXT_SIZE	5*M
#endif
#ifndef K_TEXT_SIZE /* Initial size of k_text segment. */
#define K_TEXT_SIZE	64*K	/* 64 KB */
#endif
#ifndef DATA_SIZE   /* Initial size of data segment. */
#define DATA_SIZE	3*M
#endif
#ifndef DATA_LIMIT  /* Maximum size of data segment. */
#define DATA_LIMIT	1000*M
#endif
#ifndef K_DATA_SIZE /* Initial size of k_data segment. */
#define K_DATA_SIZE	64*K	/* 64 KB */
#endif
#ifndef K_DATA_LIMIT /* Maximum size of k_data segment. */
#define K_DATA_LIMIT	1000*M	/* 1 MB */
#endif
#ifndef STACK_SIZE  /* Initial size of stack segment. */
#define STACK_SIZE	1*M	/* 64 KB */
#endif
#ifndef STACK_LIMIT /* Maximum size of stack segment. */
#define STACK_LIMIT	100*M
#endif

/* Name of the function to invoke at start up if we have symbols */
#define DEFAULT_RUN_LOCATION "__start"

/* Default number of instructions to execute. */
#define DEFAULT_RUN_STEPS 2147483647

/* Maximum size of object stored in the small data segment pointed to by $gp */
#define SMALL_DATA_SEG_MAX_SIZE 8

/* Argument passing registers */
#define REG_V0 2
#define REG_A0 4
#define REG_A1 5
#define REG_A2 6
#define REG_A3 7
#define REG_FA0 12
/* Result registers */
#define REG_RES 2
#define REG_FRES 0
#define REG_GP 28
#define REG_SP 29

/* for the cache interface */
enum {C_WRITE = 0x1, C_READ = 0x2};
enum {C_WORD =  0x1, C_HALF = 0x2, C_BYTE = 0x4};

/* Triple containing a string and two integers.	 Used in tables
   mapping from a name to values. */
typedef struct strint
{
    char *name;
    unsigned int value1;
    unsigned int value2;
} inst_info;

/* Variables:  declared in spim-utils.c */
extern int prog_fds[];                  /* for fd translation */
extern int bare_machine;		/* Simulate bare instruction set */
extern int quiet;			/* No warning messages */
extern int source_file;	       /* Program is source, not binary */
extern void *message_out, *console_out;

#ifndef OLDC
/* functions */
/* spim.c */
/* read-aout.c */
extern int read_aout_file(char *file_name);

/* spim-utils.c */
extern int init_and_run(mem_addr addr, int steps, int display, int cont, 
			int argcnt, char **argvc, char **env);
extern void init_prog_fds(void);
extern void initialize_world(int);
extern void initialize_registers(void);
extern void initialize_run_stack(int, char **, char **);
extern int init_memory(long text_size, long data_size);

extern int read_assembly_file(char *);
extern mem_addr starting_address(void);
extern int run_program(unsigned long int, int, int, int);

extern void add_breakpoint(unsigned long int);
extern void delete_breakpoint(unsigned long int);
extern void list_breakpoints(void);

extern void error(char *fmt, ...);
extern void run_error(char *fmt, ...);
extern void fatal_error(char *fmt, ...);
extern void write_output(void *f, char *fmt, ...);
extern void read_input(char *, int);

extern inst_info *map_int_to_inst_info(inst_info *, int, int);
extern inst_info *map_string_to_inst_info(inst_info *, int, char *);

/* lex.yy.c */
extern int yylex(void);
extern void initialize_scanner(FILE *);
extern void scanner_start_line(void);
extern void print_erroneous_line(void);
extern int register_name_to_number(char *);

/* y.tab.c */
extern int yyparse(void);
extern void yyerror(char *);
/* the other four are in inst.h */

/* cache.c */
extern void initcache(void);
extern void doiaccess(unsigned int, int);
extern void dodaccess(unsigned int, int, int);
extern int cache_flush(char *, int, int);
extern int cache_ctl(char *, int, int);
extern void print_cstats(void);

/* data.c */
extern void data_begins_at_point(unsigned long int);
extern void k_data_begins_at_point(unsigned long int);
extern void align_data(int);
extern void enable_data_alignment(void);
extern mem_addr current_data_pc(void);
extern void increment_data_pc(int);
extern void extern_directive(char *, int);
extern void end_of_assembly_file(void);
extern void lcomm_directive(char *, int);
extern void store_string(char *, int, int);
extern void store_byte(int);
extern void store_half(short);
extern void store_word(int);
extern void store_double(double *);
extern void store_float(double *);

/* run.c */
extern int run_spim(mem_addr initial_PC, int steps, int display);

/* mips-syscall.c */
extern int dosyscall(void);

/* except.c */
extern void setup_signal_stack(void);
extern void dosigreturn(void);
extern int handle_exception(void);

/* mem.c : mem.h */
/* inst.c: inst.h */
/* sym_tbl.c: sym_tbl.h */
#endif /* OLDC */
