/* $Header: /n/fs/vb/egs/src/spim/RCS/read-aout.c,v 1.5 92/07/08 14:54:25 egs Exp Locker: egs $
*/
#ifdef mips
#include <stdio.h>
#include <a.out.h>
#include <filehdr.h>
#include <ldfcn.h>
#endif mips

#include "spim.h"
#include "inst.h"
#include "mem.h"
#include "reg.h"
#include "sym_tbl.h"

/* Exported variables: */
int program_break;		/* Last address in data segment (edata) */

/* Imported variables: */
extern mem_addr program_starting_address;
extern int text_dir;
extern int errno;

static int read_symbols(char *filename) {
    LDFILE *ldptr;
    SYMR sym;
    int i;

    if((ldptr = ldopen (filename, NULL)) == NULL) {
	error ("Cannot read file %s for symbols\n", filename);
	return 1;
    }
    if(SYMTAB(ldptr) != NULL)
	for (i=0; i<SYMHEADER(ldptr).isymMax+SYMHEADER(ldptr).iextMax;i++){
	    char *name;
	    
	    ldtbread (ldptr, i, &sym);
	    name = (char *) ldgetname (ldptr, &sym);
	    if((sym.st == stProc) || (sym.st ==stStaticProc))
		if(find_symbol_address(name) == NULL)
		    record_label(name, sym.value);
	}
    ldclose(ldptr);
    return 0;
}

/* Read a MIPS executable file.  Return zero if successful, else non-zero */
extern int read_aout_file (char *file_name) {
#ifdef mips
    AOUTHDR header;
    struct filehdr filehdr;
    FILE *fd;
    register int i;
    long text_base, text_size;
    long data_base, data_size;
    
    bare_machine = 1;		/* Before storing into memory */
    source_file = 0;

    if((fd = fopen(file_name, "r")) == NULL) {
	error ("Cannot read the file: %s\n", file_name);
	return (1);
    }
    /* skip over the filehdr: */
    if(fread(&filehdr,1,sizeof(struct filehdr), fd) != sizeof(struct filehdr)){
	error("File does not have a proper file header\n");
	return 1;
    }
    /* read the aouthdr: */
    if (fread (&header, 1, sizeof (AOUTHDR), fd) != sizeof (AOUTHDR)) {
	error ("File had invalid format: %s\n", file_name);
	return (1);
    }
    /* a.out preface is read into core before text segment: */
    text_base = header.text_start + sizeof(struct filehdr) + sizeof(AOUTHDR);
    text_size = header.tsize -(sizeof(struct filehdr)+sizeof(AOUTHDR));
    data_base = header.data_start;
    data_size = header.dsize;
    program_break = header.bss_start + header.bsize;
    text_begins_at_point(text_base);
    data_begins_at_point(data_base);
    init_memory(text_size + 0x4000, data_size);
    text_dir = 1;
    for (i = 0;i < text_size / 4; i ++)
	store_instruction(inst_decode(getw(fd)));
    text_dir = 0;
    if (feof (fd)) {
	error ("Cannot read entire text segment: %s\n", file_name);
	return (1);
    }
    program_starting_address = header.entry;
    for (i = 0;i < data_size / 4; i ++)
	store_word (getw (fd));
    if (feof (fd))
	error ("Cannot read entire data segment: %s\n", file_name);
    fclose(fd);

    R[28 /* REG_GP */] = header.gp_value;

    return read_symbols(file_name);
#endif
}

