/* Description of (most) MIPS system calls so SPIM can pass the correct
   arguments to the system when a user program executes a syscall in
   binary mode. */

typedef struct
{
  int syscall_num;
  int syscall_type;
  int arg0;
  int arg1;
  int arg2;
  int arg3;
  int arg4;
  char *syscall_name;
} syscall_desc;

enum {BAD_SYSCALL, UNIX_SYSCALL, SPC_SYSCALL};
enum {NO_ARG, INT_ARG, ADDR_ARG, STR_ARG, FD_ARG};  /* Type of argument */

syscall_desc syscall_table[] =
{
{SYS_syscall,	SPC_SYSCALL, INT_ARG, INT_ARG, INT_ARG, INT_ARG, NO_ARG, "syscall"},
{SYS_exit,	SPC_SYSCALL, INT_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "exit"},
{SYS_fork,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "fork"},
{SYS_read,	UNIX_SYSCALL, FD_ARG, ADDR_ARG, INT_ARG, NO_ARG, NO_ARG, "read"},
{SYS_write,	UNIX_SYSCALL, FD_ARG, STR_ARG, INT_ARG, NO_ARG, NO_ARG, "write"},
{SYS_open,	SPC_SYSCALL, STR_ARG, INT_ARG, INT_ARG, NO_ARG, NO_ARG, "open"},
{SYS_close,	SPC_SYSCALL, FD_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "close"},
{7,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_creat,	SPC_SYSCALL, STR_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "creat"},
{SYS_link,	UNIX_SYSCALL, STR_ARG, STR_ARG, NO_ARG, NO_ARG, NO_ARG, "link"},
{SYS_unlink,	UNIX_SYSCALL, STR_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "unlink"},
{SYS_execv,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "execv"},
{SYS_chdir,	UNIX_SYSCALL, STR_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "chdir"},
{13,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_mknod,	UNIX_SYSCALL, STR_ARG, INT_ARG, INT_ARG, NO_ARG, NO_ARG, "mknod"},
{SYS_chmod,	UNIX_SYSCALL, STR_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "chmod"},
{SYS_chown,	UNIX_SYSCALL, STR_ARG, INT_ARG, INT_ARG, NO_ARG, NO_ARG, "chown"},
{SYS_brk,	SPC_SYSCALL, ADDR_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "brk"},
{18,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_lseek,	UNIX_SYSCALL, FD_ARG, INT_ARG, INT_ARG, NO_ARG, NO_ARG, "lseek"},
{SYS_getpid,	UNIX_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getpid"},
{SYS_mount,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "mount"},
{SYS_umount,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "umount"},
{23,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_getuid,	UNIX_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getuid"},
{25,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_ptrace,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "ptrace"},
{27,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{28,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{29,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{30,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{31,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{32,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_access,	UNIX_SYSCALL, STR_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "access"},
{34,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{35,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_sync,	UNIX_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sync"},
{SYS_kill,	UNIX_SYSCALL, INT_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "kill"},
{SYS_stat,	UNIX_SYSCALL, STR_ARG, ADDR_ARG, NO_ARG, NO_ARG, NO_ARG, "stat"},
{39,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_lstat,	UNIX_SYSCALL, STR_ARG, ADDR_ARG, NO_ARG, NO_ARG, NO_ARG, "lstat"},
{SYS_dup,	SPC_SYSCALL, FD_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "dup"},
{SYS_pipe,	UNIX_SYSCALL, ADDR_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "pipe"},
{43,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_profil,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "profil"},
{45,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{46,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_getgid,	UNIX_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getgid"},
{48,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{49,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{50,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_acct,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "acct"},
{52,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{53,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_ioctl,	UNIX_SYSCALL, FD_ARG, INT_ARG, ADDR_ARG, NO_ARG, NO_ARG, "ioctl"},
{SYS_reboot,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "reboot"},
{56,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_symlink,	UNIX_SYSCALL, STR_ARG, STR_ARG, NO_ARG, NO_ARG, NO_ARG, "symlink"},
{SYS_readlink,	UNIX_SYSCALL, ADDR_ARG, ADDR_ARG, INT_ARG, NO_ARG, NO_ARG, "readlink"},
{SYS_execve,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "execve"},
{SYS_umask,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "umask"},
{SYS_chroot,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "chroot"},
{SYS_fstat,	UNIX_SYSCALL, FD_ARG, ADDR_ARG, NO_ARG, NO_ARG, NO_ARG, "fstat"},
{63,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_getpagesize,	UNIX_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getpagesize"},
{SYS_mremap,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "mremap"},
{SYS_vfork,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "vfork"},
{67,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{68,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_sbrk,	SPC_SYSCALL, INT_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sbrk"},
{SYS_sstk,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sstk"},
{SYS_mmap,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "mmap"},
{SYS_vadvise,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "vadvise"},
{SYS_munmap,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "munmap"},
{SYS_mprotect,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "mprotect"},
{SYS_madvise,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "madvise"},
{SYS_vhangup,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "vhangup"},
{77,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_mincore,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "mincore"},
{SYS_getgroups,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getgroups"},
{SYS_setgroups,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setgroups"},
{SYS_getpgrp,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getpgrp"},
{SYS_setpgrp,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setpgrp"},
{SYS_setitimer,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setitimer"},
{SYS_wait3,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "wait3"},
{SYS_swapon,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "swapon"},
{SYS_getitimer,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getitimer"},
{SYS_gethostname, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "gethostname"},
{SYS_sethostname, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sethostname"},
{SYS_getdtablesize, UNIX_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getdtablesize"},
{SYS_dup2,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "dup2"},
{SYS_getdopt,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getdopt"},
{SYS_fcntl,	UNIX_SYSCALL, FD_ARG, INT_ARG, INT_ARG, NO_ARG, NO_ARG, "fcntl"},
{SYS_select,	SPC_SYSCALL, INT_ARG, ADDR_ARG, ADDR_ARG, ADDR_ARG, ADDR_ARG, "select"},
{SYS_setdopt,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setdopt"},
{SYS_fsync,	UNIX_SYSCALL, FD_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "fsync"},
{SYS_setpriority, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setpriority"},
{SYS_socket,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "socket"},
{SYS_connect,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "connect"},
{SYS_accept,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "accept"},
{SYS_getpriority, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getpriority"},
{SYS_send,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "send"},
{SYS_recv,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "recv"},
{SYS_sigreturn,	SPC_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sigreturn"},
{SYS_bind,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "bind"},
{SYS_setsockopt, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setsockopt"},
{SYS_listen,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "listen"},
{107,           BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_sigvec,	SPC_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sigvec"},
{SYS_sigblock,	SPC_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sigblock"},
{SYS_sigsetmask, SPC_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sigsetmask"},
{SYS_sigpause,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sigpause"},
{SYS_sigstack,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sigstack"},
{SYS_recvmsg,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "recvmsg"},
{SYS_sendmsg,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sendmsg"},
{115,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_gettimeofday, UNIX_SYSCALL, ADDR_ARG, ADDR_ARG, NO_ARG, NO_ARG, NO_ARG, "gettimeofday"},
{SYS_getrusage,	UNIX_SYSCALL, INT_ARG, ADDR_ARG, NO_ARG, NO_ARG, NO_ARG, "getrusage"},
{SYS_getsockopt, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getsockopt"},
{119,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_readv,	UNIX_SYSCALL, FD_ARG, ADDR_ARG, INT_ARG, NO_ARG, NO_ARG, "readv"},
{SYS_writev,	UNIX_SYSCALL, FD_ARG, ADDR_ARG, INT_ARG, NO_ARG, NO_ARG, "writev"},
{SYS_settimeofday, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "settimeofday"},
{SYS_fchown,	UNIX_SYSCALL, FD_ARG, INT_ARG, INT_ARG, NO_ARG, NO_ARG, "fchown"},
{SYS_fchmod,	UNIX_SYSCALL, FD_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "fchmod"},
{SYS_recvfrom,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "recvfrom"},
{SYS_setreuid,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setreuid"},
{SYS_setregid,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setregid"},
{SYS_rename,	UNIX_SYSCALL, STR_ARG, STR_ARG, NO_ARG, NO_ARG, NO_ARG, "rename"},
{SYS_truncate,	UNIX_SYSCALL, STR_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "truncate"},
{SYS_ftruncate,	UNIX_SYSCALL, FD_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "ftruncate"},
{SYS_flock,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "flock"},
{132,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_sendto,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sendto"},
{SYS_shutdown,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "shutdown"},
{SYS_socketpair, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "socketpair"},
{SYS_mkdir,	UNIX_SYSCALL, STR_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "mkdir"},
{SYS_rmdir,	UNIX_SYSCALL, STR_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "rmdir"},
{SYS_utimes,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "utimes"},
{SYS_sigcleanup, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sigcleanup"},
{SYS_adjtime,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "adjtime"},
{SYS_getpeername, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getpeername"},
{SYS_gethostid,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "gethostid"},
{SYS_sethostid,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "sethostid"},
{SYS_getrlimit,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getrlimit"},
{SYS_setrlimit,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setrlimit"},
{SYS_killpg,	UNIX_SYSCALL, INT_ARG, INT_ARG, NO_ARG, NO_ARG, NO_ARG, "killpg"},
{147,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_setquota,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "setquota"},
{SYS_quota,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "quota"},
{SYS_getsockname, BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "getsockname"},
{SYS_sysmips,	SPC_SYSCALL, INT_ARG, INT_ARG, INT_ARG, INT_ARG, INT_ARG, "sysmips"},
{SYS_cacheflush, SPC_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "cacheflush"},
{SYS_cachectl,	SPC_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "cachectl"},
{154,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, ""},
{SYS_atomic_op,	BAD_SYSCALL, NO_ARG, NO_ARG, NO_ARG, NO_ARG, NO_ARG, "atomic_op"},
};

#define MAX_SYSCALL	(sizeof(syscall_table)/ sizeof(syscall_table[0]))

#define SYSCALL_ARG(REGOFF, ARG, REG)        			             \
  ((syscall_table[R[REGOFF]].ARG == ADDR_ARG) ? MEM_ADDRESS(R[REG]) :        \
   (syscall_table[R[REGOFF]].ARG == STR_ARG) ? MEM_ADDRESS(R[REG])  :        \
   ((syscall_table[R[REGOFF]].ARG == FD_ARG) && (R[REG] < MAXFDS))  ?        \
                                                   prog_fds[R[REG]] : R[REG])

#define PARG(ARG, REGOFF, REG, COMMA)                                      \
                      if(syscall_table[R[REGOFF]].ARG != NO_ARG) {         \
                         if(COMMA) fprintf(stderr, ", ");                  \
                         if(syscall_table[R[REGOFF]].ARG == STR_ARG)       \
			    fprintf(stderr, "\"%s\"", (char *) SYSCALL_ARG(REGOFF, ARG, REG));    \
                         else                                              \
			    fprintf(stderr, "0x%x", R[REG]);               \
                      }

#define SYSTRACE(REGOFF, REG0, REG1, REG2, REG3) \
		  if(systrace) {                                           \
		      fprintf(stderr, "SYSCALL %s(", syscall_table[R[REGOFF]].syscall_name);                                                            \
                      PARG(arg0, REGOFF, REG0, 0)                        \
                      PARG(arg1, REGOFF, REG1, 1)                        \
                      PARG(arg2, REGOFF, REG2, 1)                        \
                      PARG(arg3, REGOFF, REG3, 1)                        \
                      PARG(arg4, REGOFF, REG3, 1)                        \
		      fprintf(stderr,") = ");                            \
		  }

