#ifdef ibm032
#define BYTE_TYPE signed char
#else
#define BYTE_TYPE char
#endif

#define TEXT_BOT   ((mem_addr) 0x00400000)
#define DATA_BOT   ((mem_addr) 0x10000000)
#define STACK_TOP  ((mem_addr) 0x7fffc000)
#define K_TEXT_BOT ((mem_addr) 0x80000000)
#define K_DATA_BOT ((mem_addr) 0x90000000)

/* these should be externs and someone should define them */
typedef unsigned long mem_word;
instruction **text_seg;
mem_addr text_top;
mem_word *data_seg;
mem_addr data_top;
mem_addr gp_midpoint;		/* Middle of $gp area */
mem_word *stack_seg;
mem_addr stack_bot;
instruction **k_text_seg;
mem_addr k_text_top;
mem_word *k_data_seg;
mem_addr k_data_top;

extern int text_modified;	/* Non-zero means text segment was written */
extern int data_modified;       /* Non-zero means a data segment was written */

extern int byteshift[], wordshift[];

/* Amount to grow text segment when we run out of space for instructions. */
#define TEXT_CHUNK_SIZE	4096

/* Do we really need these ?? */
short *data_seg_h;		/* Points to same vector as DATA_SEG */
BYTE_TYPE *data_seg_b;		/* Ditto */
short *stack_seg_h;		/* Points to same vector as STACK_SEG */
BYTE_TYPE *stack_seg_b;		/* Ditto */
short *k_data_seg_h;
BYTE_TYPE *k_data_seg_b;

extern int make_memory(long int, long int, long int, long int, long int);
extern void deallocate_mem(void);
extern void expand_data(long int);
extern void expand_stack(long int);
extern void expand_k_data(long int);
extern instruction *funny_text_read(mem_addr);
extern void funny_text_write(mem_addr, instruction *);
extern mem_addr bad_mem_read(mem_addr, int, mem_word *);
extern void bad_mem_write(mem_addr, mem_word, int);
extern void print_mem(mem_addr);

/* You would think that a compiler could perform CSE on the arguments to
   these macros.  However, complex expressions break some compilers, so
   do the CSE ourselves. */

/* Translate from SPIM memory address to physical address */

#define MEM_ADDRESS(ADDR)						   \
(((mem_addr) (ADDR) >= TEXT_BOT && (mem_addr) (ADDR) < text_top)	   \
 ? (mem_addr) (ADDR) - TEXT_BOT + (mem_addr) text_seg			   \
 : (((mem_addr) (ADDR) >= DATA_BOT && (mem_addr) (ADDR) < data_top)	   \
    ? (mem_addr) (ADDR) - DATA_BOT + (mem_addr) data_seg		   \
    : (((mem_addr) (ADDR) >= stack_bot && (mem_addr) (ADDR) < STACK_TOP)   \
       ? (mem_addr) (ADDR) - stack_bot + (mem_addr) stack_seg		   \
       : ((mem_addr) (ADDR) >= K_TEXT_BOT && (mem_addr) (ADDR) < k_text_top)\
       ? (mem_addr) (ADDR) - K_TEXT_BOT + (mem_addr) k_text_seg		   \
       : (((mem_addr) (ADDR) >= K_DATA_BOT && (mem_addr) (ADDR) < k_data_top)\
	  ? (mem_addr) (ADDR) - K_DATA_BOT + (mem_addr) k_data_seg	   \
	  : (run_error ("Memory address out of bounds\n"),0)))))


#define READ_MEM_INST_RECORD(LOC, ADDR, RECORD)				   \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
      if(RECORD) doiaccess(_addr_, C_READ); \
   if (_addr_ >= TEXT_BOT && _addr_ < text_top && !(_addr_ & 0x3))	   \
     LOC = text_seg [(_addr_ - TEXT_BOT) >> 2];				   \
   else if (_addr_ >= K_TEXT_BOT && _addr_ < k_text_top && !(_addr_ & 0x3))\
     LOC = k_text_seg [(_addr_ - K_TEXT_BOT) >> 2];			   \
   else LOC = funny_text_read (_addr_);}


#define READ_MEM_BYTE_RECORD(LOC, ADDR, RECORD)				   \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
     if(RECORD) dodaccess(_addr_,C_READ,C_BYTE); \
   if (_addr_ >= TEXT_BOT && _addr_ < text_top)	                           \
       LOC = ((text_seg[(_addr_ - TEXT_BOT) >> 2]->word) >>                \
	   byteshift[_addr_ & 0x3]) & 0xff;                                \
   else if (_addr_ >= DATA_BOT && _addr_ < data_top)			   \
       LOC = data_seg_b [_addr_ - DATA_BOT];				   \
   else if (_addr_ >= stack_bot && _addr_ < STACK_TOP)			   \
       LOC = stack_seg_b [_addr_ - stack_bot];				   \
   else if (_addr_ >= K_DATA_BOT && _addr_ < k_data_top)		   \
       LOC = k_data_seg_b [_addr_ - K_DATA_BOT];			   \
   else									   \
       LOC = bad_mem_read (_addr_, 0, (mem_word *) &LOC);}


#define READ_MEM_HALF_RECORD(LOC, ADDR, RECORD)				   \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
     if(RECORD) dodaccess(_addr_,C_READ,C_HALF); \
   if (_addr_ >= TEXT_BOT && _addr_ < text_top && !(_addr_ & 0x1))         \
       LOC = ((text_seg[(_addr_ - TEXT_BOT) >> 2]->word) >>                \
	   wordshift[_addr_ & 0x3]) & 0xffff;                              \
   else if (_addr_ >= DATA_BOT && _addr_ < data_top && !(_addr_ & 0x1))	   \
       LOC = data_seg_h [(_addr_ - DATA_BOT) >> 1];			   \
   else if (_addr_ >= stack_bot && _addr_ < STACK_TOP && !(_addr_ & 0x1))  \
       LOC = stack_seg_h [(_addr_ - stack_bot) >> 1];			   \
   else if (_addr_ >= K_DATA_BOT && _addr_ < k_data_top && !(_addr_ & 0x1))\
       LOC = k_data_seg_h [(_addr_ - K_DATA_BOT) >> 1];			   \
  else									   \
    LOC = bad_mem_read (_addr_, 0x1, (mem_word *) &LOC);}


#define READ_MEM_WORD_RECORD(LOC, ADDR, RECORD)				   \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
     if(RECORD) dodaccess(_addr_,C_READ,C_WORD); \
   if (_addr_ >= TEXT_BOT && _addr_ < text_top && !(_addr_ & 0x3))	   \
       LOC = text_seg[(_addr_ - TEXT_BOT) >> 2]->word;                     \
  else if (_addr_ >= DATA_BOT && _addr_ < data_top && !(_addr_ & 0x3))	   \
     LOC = data_seg [(_addr_ - DATA_BOT) >> 2];				   \
  else if (_addr_ >= stack_bot && _addr_ < STACK_TOP && !(_addr_ & 0x3))   \
    LOC = stack_seg [(_addr_ - stack_bot) >> 2];			   \
   else if (_addr_ >= K_DATA_BOT && _addr_ < k_data_top && !(_addr_ & 0x3))\
     LOC = k_data_seg [(_addr_ - K_DATA_BOT) >> 2];			   \
  else									   \
    LOC = bad_mem_read (_addr_, 0x3, (mem_word *) &LOC);}


#define SET_MEM_INST_RECORD(ADDR, INST, RECORD)		                   \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
   text_modified = 1;							   \
       if(RECORD) doiaccess(_addr_,C_WRITE); \
   if (_addr_ >= TEXT_BOT && _addr_ < text_top && !(_addr_ & 0x3))	   \
     text_seg [(_addr_ - TEXT_BOT) >> 2] = INST;			   \
   else if (_addr_ >= K_TEXT_BOT && _addr_ < k_text_top && !(_addr_ & 0x3))\
     k_text_seg [(_addr_ - K_TEXT_BOT) >> 2] = INST;			   \
   else funny_text_write (_addr_, INST);}


#define SET_MEM_BYTE_RECORD(ADDR, VALUE, RECORD)			   \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
   data_modified = 1;							   \
     if(RECORD) dodaccess(_addr_,C_WRITE,C_BYTE); \
   if (_addr_ >= DATA_BOT && _addr_ < data_top)				   \
     data_seg_b [_addr_ - DATA_BOT] = (unsigned char) (VALUE);		   \
   else if (_addr_ >= stack_bot && _addr_ < STACK_TOP)			   \
     stack_seg_b [_addr_ - stack_bot] = (unsigned char) (VALUE);	   \
   else if (_addr_ >= K_DATA_BOT && _addr_ < k_data_top)		   \
     k_data_seg_b [_addr_ - K_DATA_BOT] = (unsigned char) (VALUE);	   \
   else bad_mem_write (_addr_, VALUE, 0);}


#define SET_MEM_HALF_RECORD(ADDR, VALUE, RECORD)			   \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
   data_modified = 1;							   \
     if(RECORD) dodaccess(_addr_,C_WRITE,C_HALF); \
   if (_addr_ >= DATA_BOT && _addr_ < data_top && !(_addr_ & 0x1))	   \
     data_seg_h [(_addr_ - DATA_BOT) >> 1] = (unsigned short) (VALUE);	   \
   else if (_addr_ >= stack_bot && _addr_ < STACK_TOP && !(_addr_ & 0x1))  \
     stack_seg_h [(_addr_ - stack_bot) >> 1] = (unsigned short) (VALUE);   \
   else if (_addr_ >= K_DATA_BOT && _addr_ < k_data_top && !(_addr_ & 0x1))\
     k_data_seg_h [(_addr_ - K_DATA_BOT) >> 1] = (unsigned short) (VALUE); \
   else bad_mem_write (_addr_, VALUE, 0x1);}


#define SET_MEM_WORD_RECORD(ADDR, VALUE, RECORD)		           \
{register mem_addr _addr_ = (mem_addr) (ADDR);				   \
   data_modified = 1;							   \
     if(RECORD) dodaccess(_addr_,C_WRITE,C_WORD); \
   if (_addr_ >= DATA_BOT && _addr_ < data_top && !(_addr_ & 0x3))	   \
     data_seg [(_addr_ - DATA_BOT) >> 2] = (mem_word) (VALUE);		   \
   else if (_addr_ >= stack_bot && _addr_ < STACK_TOP && !(_addr_ & 0x3))  \
     stack_seg [(_addr_ - stack_bot) >> 2] = (mem_word) (VALUE);	   \
   else if (_addr_ >= K_DATA_BOT && _addr_ < k_data_top && !(_addr_ & 0x3))\
     k_data_seg [(_addr_ - K_DATA_BOT) >> 2] = (mem_word) (VALUE);	   \
   else bad_mem_write (_addr_, VALUE, 0x3);}

#define     READ_MEM_INST(LOC, ADDR)        READ_MEM_INST_RECORD(LOC, ADDR, 1)
#define     READ_MEM_BYTE(LOC, ADDR)        READ_MEM_BYTE_RECORD(LOC, ADDR, 1)
#define     READ_MEM_HALF(LOC, ADDR)        READ_MEM_HALF_RECORD(LOC, ADDR, 1)
#define     READ_MEM_WORD(LOC, ADDR)        READ_MEM_WORD_RECORD(LOC, ADDR, 1)
#define     SET_MEM_INST(ADDR, INST)        SET_MEM_INST_RECORD(ADDR, INST, 1)
#define     SET_MEM_BYTE(ADDR, VALUE)       SET_MEM_BYTE_RECORD(ADDR, VALUE, 1)
#define     SET_MEM_HALF(ADDR, VALUE)       SET_MEM_HALF_RECORD(ADDR, VALUE, 1)
#define     SET_MEM_WORD(ADDR, VALUE)       SET_MEM_WORD_RECORD(ADDR, VALUE, 1)

#define READ_MEM_INST_NORECORD(LOC, ADDR) READ_MEM_INST_RECORD(LOC, ADDR, 0)
#define READ_MEM_BYTE_NORECORD(LOC, ADDR) READ_MEM_BYTE_RECORD(LOC, ADDR, 0)
#define READ_MEM_HALF_NORECORD(LOC, ADDR) READ_MEM_HALF_RECORD(LOC, ADDR, 0)
#define READ_MEM_WORD_NORECORD(LOC, ADDR) READ_MEM_WORD_RECORD(LOC, ADDR, 0)
#define SET_MEM_INST_NORECORD(ADDR, INST) SET_MEM_INST_RECORD(ADDR, INST, 0)
#define SET_MEM_BYTE_NORECORD(ADDR, VALUE) SET_MEM_BYTE_RECORD(ADDR, VALUE, 0)
#define SET_MEM_HALF_NORECORD(ADDR, VALUE) SET_MEM_HALF_RECORD(ADDR, VALUE, 0)
#define SET_MEM_WORD_NORECORD(ADDR, VALUE) SET_MEM_WORD_RECORD(ADDR, VALUE, 0)
