#ifdef mips
#include <syscall.h>
#include "/usr/include/signal.h"
#endif
#include <math.h>
#include <stdio.h>

#include "spim.h"
#include "inst.h"
#include "mem.h"
#include "reg.h"
#include "spim-syscall.h"
#include "sym_tbl.h"

extern struct sigvec sighandler[];
extern int prog_sigmask;
extern mem_addr exception_address;

extern void setup_signal_stack(void) {
    int i;
    struct sigcontext *sc;

    R[29] -= sizeof(struct sigcontext) + 4;
    sc = (struct sigcontext *) MEM_ADDRESS(R[29]);
    sc->sc_onstack = 0 /**/;
    sc->sc_mask = prog_sigmask;
    sc->sc_pc = EPC;
    for(i=0; i < 32; ++i) /* general purpose registers */
	sc->sc_regs[i] = R[i];
    sc->sc_mdlo = LO;        /* mul/div low */
    sc->sc_mdhi = HI;
    sc->sc_ownedfp = 0;     /* fp has been used */
    for(i=0; i < 32; ++i) /* FPU registers */
	sc->sc_fpregs[i] = FPR[i];
    sc->sc_fpc_csr = 0 /**/;     /* floating point control and status reg */
    sc->sc_fpc_eir = 0 /**/;
    sc->sc_cause = Cause;       /* cp0 cause register */
    sc->sc_badvaddr = BadVAddr;    /* cp0 bad virtual address */
    sc->sc_badpaddr = 0 /**/;    /* cpu bd bad physical address */
}

extern void dosigreturn(void) {
    int i;
    struct sigcontext *sc;

    sc = (struct sigcontext *) MEM_ADDRESS(R[29] + 32);
    prog_sigmask = sc->sc_mask;
    PC = sc->sc_pc - BYTES_PER_WORD;
    for(i=0; i < 32; ++i)
	R[i] = sc->sc_regs[i];
    LO = sc->sc_mdlo;
    HI = sc->sc_mdhi;
    for(i=0; i < 32; ++i) /* FPU registers */
	FPR[i] = sc->sc_fpregs[i];
    Cause = sc->sc_cause;
    BadVAddr = sc->sc_badvaddr;
    R[29] += sizeof(struct sigcontext) + 4;
}

extern int handle_exception(void) {

    switch (Cause >> 2) 	    {
    case  INT_EXCPT:
	R[REG_A0] = SIGINT;
	error ("  Interrupt exception\n"); break;
    case ADDRL_EXCPT:
	R[REG_A0] = SIGSEGV;
	error ("  Unaligned address in inst/data fetch: 0x%08x\n",BadVAddr); 
	break;
    case ADDRS_EXCPT:
	R[REG_A0] = SIGSEGV;
	error ("  Unaligned address in store: 0x%08x\n", BadVAddr);break;
    case IBUS_EXCPT:
	R[REG_A0] = SIGBUS;
	error ("  Bad address in text read: 0x%08x\n", BadVAddr); break;
    case DBUS_EXCPT:
	R[REG_A0] = SIGBUS;
	error ("  Bad address in data/stack read: 0x%08x\n", BadVAddr);
	break;
    case BKPT_EXCPT: 
	exception_occurred = 0;
	return(0);
    case SYSCALL_EXCPT:
	error ("  Error in syscall\n"); break;
    case RI_EXCPT:
	error ("  Reserved instruction execution\n"); break;
    case OVF_EXCPT:
	R[REG_A0] = SIGFPE;
	error ("  Arithmetic overflow\n"); break;
    case CLOCK_EXCPT:
	error ("  Clock interrupt\n"); break;
    case IO_EXCPT:
	error ("  IO interrupt\n"); break;
    default:
	error ("Unknown exception: %d\n", Cause >> 2); break;
    }
    exception_occurred = 0;
    if((prog_sigmask & (1 << R[REG_A0])) == 1)
	return 0;
    if((int) sighandler[R[REG_A0]].sv_handler == 0) {
	/*	  PC = EXCEPTION_ADDR; */
	run_error ("Exception occurred at PC=0x%08x\nNo handler for this trap. Abnormal exit.\n", EPC);
    }
    setup_signal_stack();
    R[REG_A1] = 48;

/*     printf("SP for sigvec %x\n",R[29]); */
    R[REG_A2] = R[29]; 
    R[REG_A3] = (int) sighandler[R[REG_A0]].sv_handler;
/*     printf("PC to sigjump = 0x%x %d\n" ,(int) sighandler[R[REG_A0]].sv_handler, R[REG_A0]); */
    if((PC = exception_address) == 0) 
	PC = (int) find_symbol_address("sigvec") + 44;
    return(0);
}

