(*  Title: 	LK/ruleshell
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Rules for classical first-order sequent calculus 

After updating, rebuild  ".rules.ML"  by calling   "make-rulenames"   
*)


signature LK_RULE =
  sig
  structure LK_Syntax: LK_SYNTAX and Pure: PURE
	sharing LK_Syntax.Syntax = Pure.Sign.Syntax
  val sign: Pure.Sign.sg
  val thy: Pure.theory
(*INSERT-RULESIG -- file produced by make-rulenames*)
  end;


functor LK_RuleFun (structure LK_Syntax: LK_SYNTAX and Pure: PURE
	sharing LK_Syntax.Syntax = Pure.Sign.Syntax) : LK_RULE = 
struct
structure LK_Syntax = LK_Syntax;
structure Pure = Pure;
local open Pure 
in

val thy = enrich_theory pure_thy "LK"
    (["term","sobj","form","prop"],  LK_Syntax.const_decs,  LK_Syntax.syn) 
[
  (*Structural rules*)

  ("basic",   "$H, P, $G |- $E, P, $F"),

  ("thin_right",  "$H |- $E, $F ==> $H |- $E, P, $F"),
  ("thin_left",   "$H, $G |- $E ==> $H, P, $G |- $E"),

  ("cut",    "[| $H |- $E, P;  $H, P |- $E |] ==> $H |- $E"),

  (*Propositional rules*)

  ("conj_right", "[| $H|- $E, P, $F;  $H|- $E, Q, $F |] ==> $H|- $E, P&Q, $F"),
  ("conj_left",  "$H, P, Q, $G |- $E ==> $H, P & Q, $G |- $E"),

  ("disj_right", "$H |- $E, P, Q, $F ==> $H |- $E, P|Q, $F"),
  ("disj_left",
     "[| $H, P, $G |- $E;  $H, Q, $G |- $E |] ==> $H, P|Q, $G |- $E"),

  ("imp_right",  "$H, P |- $E, Q, $F ==> $H |- $E, P-->Q, $F"),
  ("imp_left","[| $H,$G |- $E,P;  $H, Q, $G |- $E |] ==> $H, P-->Q, $G |- $E"),

  ("not_right",  "$H, P |- $E, $F ==> $H |- $E, ~P, $F"),
  ("not_left",   "$H, $G |- $E, P ==> $H, ~P, $G |- $E"),

  ("iff_def",  "P<->Q == (P-->Q) & (Q-->P)"),

  (*Quantifiers*)

  ("all_right",  "(!x.$H |- $E, P(x), $F) ==> $H |- $E, ALL x.P(x), $F"),
  ("all_left",  "$H, P(a), $G, ALL x.P(x) |- $E ==> $H, ALL x.P(x), $G |- $E"),

  ("exists_right","$H |- $E, P(a), $F, EX x.P(x) ==> $H |- $E, EX x.P(x), $F"),
  ("exists_left",
      "(!x.$H, P(x), $G |- $E) ==> $H, EX x.P(x), $G |- $E"),

  (*Equality*)

  ("refl",  "$H |- $E, a=a, $F"),
  ("sym",   "$H |- $E, a=b, $F ==> $H |- $E, b=a, $F"),
  ("trans", "[| $H|- $E, a=b, $F;  $H|- $E, b=c, $F |] ==> $H|- $E, a=c, $F"),


  (*Descriptions*)

  ("The", "[| $H |- $E, P(a), $F;  !y.$H, P(y) |- $E, y=a, $F |] ==> \
\          $H |- $E, P(THE x.P(x)), $F")
];

val sign = sign_of thy;
val ax = get_axiom thy;

(*INSERT-RULENAMES -- file produced by make-rulenames*)
end;
end;
