(*  Title: 	HOL/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Adds Classical Higher-order Logic to a database containing pure Isabelle. 
Should be executed in the subdirectory HOL.

To build system, enter Poly/ML and type
    PolyML.use "ROOT.ML";
*)

writeln"Root file for Classical Higher-order Logic";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "lemmas.ML";
use "prover.ML";

print_depth 1;  
structure HOL_Syntax = HOL_SyntaxFun(Syntax);
structure HOL_Rule = HOL_RuleFun
    (structure HOL_Syntax=HOL_Syntax and Pure=Pure);
structure HOL_Lemmas = HOL_LemmasFun(HOL_Rule);

print_depth 0;  
open Pure;
open HOL_Syntax HOL_Rule HOL_Lemmas;
print_depth 1;  

Unify.printer := Syntax.prin syn;
commit();

use "class.ML";	(*Creation of theorem provers using functor ProverFun.*)
use "simp.ML";
use "types.ML";
use "tarski.ML";
use "wf.ML";
use "arith.ML";
use "list.ML";
use "rew.ML";	(*Creation of simplifier*)

print_depth 8;  
                
