(*  Title: 	FOL/ex/if
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

First-Order Logic: the 'if' example
*)

writeln"File FOL/ex/if.";

Pretty.margin:=72;

print_depth 8;

val if_thy = 
  extend_theory cla_thy "if"
    ([],   [ (["if"], [Aform,Aform,Aform]--->Aform) ])
    [ ("if_def", "if(P,Q,R) == P&Q | ~P & R") ];

val if_def = get_axiom if_thy "if_def";

val prems = goal if_thy "[| P ==> Q; ~P ==> R |] ==> if(P,Q,R)";
by (rewrite_goals_tac [if_def]);
by (Pc.fast_tac prems 1);
val if_intr = result();

val prems = goal if_thy
   "[| if(P,Q,R);  [| P; Q |] ==> S; [| ~P; R |] ==> S |] ==> S";
by (cut_facts_tac prems 1);
by (rewrite_goals_tac [if_def]);
by (Pc.fast_tac prems 1);
val if_elim = result();

map (rewrite_rule [if_def]) prems;
prths it;


goal if_thy
    "if(P, if(Q,A,B), if(Q,C,D)) <-> if(Q, if(P,A,C), if(P,B,D))";
by (resolve_tac [iff_intr] 1);
by (eresolve_tac [if_elim] 1);
by (eresolve_tac [if_elim] 1);
by (resolve_tac [if_intr] 1);
by (resolve_tac [if_intr] 1);

choplev 0;
by (REPEAT (assume_tac 1
    ORELSE mp_tac 1
    ORELSE eresolve_tac [if_elim] 1
    ORELSE resolve_tac [iff_intr,if_intr] 1));
val if_commute = result();


goal if_thy
    "if(if(P,Q,R), A, B) <-> if(P, if(Q,A,B), if(R,A,B))";
by (REPEAT (Pc.step_tac [if_intr] 1 ORELSE eresolve_tac [if_elim] 1));
val nested_ifs = result();

choplev 0;
by (rewrite_goals_tac [if_def]);
by (Pc.fast_tac [] 1);


(*INVALID*)
goal if_thy
    "if(if(P,Q,R), A, B) <-> if(P, if(Q,A,B), if(R,B,A))";
by (REPEAT (Pc.step_tac [if_intr] 1 ORELSE eresolve_tac [if_elim] 1));

choplev 0;
by (rewrite_goals_tac [if_def]);
by (REPEAT (Pc.step_tac [] 1));


writeln"Reached end of file.";
