(*  Title: 	FOL/ex/foundn
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Intuitionistic FOL: Examples from The Foundation of a Generic Theorem Prover
*)

writeln"File FOL/ex/foundn.";

goal Int_Rule.thy "A&B  --> (C-->A&C)";
by (resolve_tac [imp_intr] 1);
by (resolve_tac [imp_intr] 1);
by (resolve_tac [conj_intr] 1);
by (assume_tac 2);
by (resolve_tac [conjunct1] 1);
by (assume_tac 1);
result();

val prems = 
goal Int_Rule.thy "A&B ==> ([| A;  B |] ==> C) ==> C";
by (resolve_tac prems 1);
by (resolve_tac [conjunct1] 1);
by (resolve_tac prems 1);
by (resolve_tac [conjunct2] 1);
by (resolve_tac prems 1);
result();


val prems = 
goal Int_Rule.thy "(!A. ~ ~A ==> A) ==> B | ~B";
by (resolve_tac prems 1);
by (resolve_tac [not_intr] 1);
by (res_inst_tac [ ("P", "~B", Aform) ]  contr  1);
by (resolve_tac [not_intr] 2);
by (res_inst_tac [ ("P", "B | ~ B", Aform) ]  contr  2);
by (assume_tac 2);
by (resolve_tac [disj_intr1] 2);
by (assume_tac 2);
by (resolve_tac [not_intr] 1);
by (res_inst_tac [ ("P", "B | ~ B", Aform) ]  contr  1);
by (assume_tac 1);
by (resolve_tac [disj_intr2] 1);
by (assume_tac 1);
result();


val prems = 
goal Int_Rule.thy "(!A. ~ ~A ==> A) ==> B | ~B";
by (resolve_tac prems 1);
by (resolve_tac [not_intr] 1);
by (resolve_tac [contr] 1);
by (resolve_tac [not_intr] 2);
by (eresolve_tac [contr] 2);
by (eresolve_tac [disj_intr1] 2);
by (resolve_tac [not_intr] 1);
by (eresolve_tac [contr] 1);
by (eresolve_tac [disj_intr2] 1);
result();


val prems = 
goal Int_Rule.thy "[| A | ~A;  ~ ~A |] ==> A";
by (resolve_tac [disj_elim] 1);
by (resolve_tac prems 1);
by (assume_tac 1);
by (resolve_tac [False_elim] 1);
by (res_inst_tac [ ("P", "~A", Aform) ]  contr  1);
by (resolve_tac prems 1);
by (assume_tac 1);
result();


writeln"Examples with quantifiers";

val prems =
goal Int_Rule.thy "ALL z. G(z) ==> ALL z. G(z)|H(z)";
by (resolve_tac [all_intr] 1);
by (resolve_tac [disj_intr1] 1);
by (resolve_tac [spec RESN (1,prems)] 1); 
  (*can use instead
    by (resolve_tac [spec] 1);  by (resolve_tac prems 1); *)
result();


goal Int_Rule.thy "ALL x. EX y. x=y";
by (resolve_tac [all_intr] 1);
by (resolve_tac [exists_intr] 1);
by (resolve_tac [refl] 1);
result();


goal Int_Rule.thy "EX y. ALL x. x=y";
by (resolve_tac [exists_intr] 1);
by (resolve_tac [all_intr] 1);
by (resolve_tac [refl] 1) handle ERROR => writeln"Failed, as expected";  
getgoal 1; 


(*Parallel lifting example. *)
goal Int_Rule.thy "EX u.ALL x.EX v.ALL y.EX w. P(u,x,v,y,w)";
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);
by (resolve_tac [exists_intr, all_intr] 1);


val prems =
goal Int_Rule.thy "(EX z.F(z)) & B ==> (EX z. F(z) & B)";
by (resolve_tac [conj_elim] 1);
by (resolve_tac prems 1);
by (resolve_tac [exists_elim] 1);
by (assume_tac 1);
by (resolve_tac [exists_intr] 1);
by (resolve_tac [conj_intr] 1);
by (assume_tac 1);
by (assume_tac 1);
result();


(*A bigger demonstration of quantifiers -- not in the paper*)
goal Int_Rule.thy "(EX y. ALL x. Q(x,y)) -->  (ALL x. EX y. Q(x,y))";
by (resolve_tac [imp_intr] 1);
by (resolve_tac [all_intr] 1);
by (resolve_tac [exists_elim] 1 THEN assume_tac 1);
by (resolve_tac [exists_intr] 1);
by (resolve_tac [all_elim] 1 THEN assume_tac 1);
by (assume_tac 1);
result();  


writeln"Reached end of file.";
