(*  Title: 	Parse Tree
    Author: 	Tobias Nipkow
*)

signature PARSE_TREE =
sig
  structure Lexicon: LEXICON
  datatype ParseTree = Node of string * ParseTree list |
                       Tip of Lexicon.Token
  val mk_pt: string * ParseTree list -> ParseTree
  val pt_to_term: (string -> (term list -> term) option) -> ParseTree -> term
end;


functor PARSE_TREE_FUN(Lexicon:LEXICON): PARSE_TREE =
struct

structure Lexicon = Lexicon;

datatype ParseTree = Node of string * ParseTrees |
                     Tip of Lexicon.Token
withtype ParseTrees = ParseTree list;

exception PARSE_TREE;

fun mk_pt("",[pt]) = pt
  | mk_pt("",ptl) = error"System bug - Funny copy op in parse tree.\n"
  | mk_pt(s,ptl) = Node(s,ptl);

(* Translation from parse trees to terms: *)

fun trans_err opn =
	error("Exception in user supplied translation for "^opn^".\n");

fun pt_to_term trf =
    let fun trav (Node(opn,ptl)) =
              let val args = map trav ptl
              in case trf opn of
                   None => let val const = Const(opn,Adummy)
                           in if null args then const
                              else itlist_left (op$) (const,args) end |
                   Some f => (f args handle ? => trans_err opn)
              end
          | trav (Tip(Lexicon.IdentSy(id))) = Free(id,Adummy)
          | trav (Tip(Lexicon.VarSy(id,ix))) = Var((id,ix),Adummy)
          | trav _ = error"System bug - Unexpected terminal in parse tree.\n";
    in trav end;

end;
