(*  Title: 	CTT/bool
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

The two-element type (booleans and conditionals)
*)

val bool_const_decs = 
  [ (["Bool"],		Atype ),
    (["true","false"],	Aterm ),
    (["cond"],		[Aterm,Aterm,Aterm]--->Aterm ) ];

val bool_thy = extend_theory CTT_Rule.thy "bool" 
    ([], bool_const_decs)
  [ ("Bool_def",  "Bool == T+T"),
    ("true_def",  "true == inl(tt)"),
    ("false_def", "false == inr(tt)"),
    ("cond_def",  "cond(a,b,c) == when(a, %u.b, %u.c)") ];


val ax = get_axiom bool_thy;

val Bool_def = ax"Bool_def";
val true_def = ax"true_def";
val false_def = ax"false_def";
val cond_def = ax"cond_def";

val bool_defs = [Bool_def,true_def,false_def,cond_def];


