(*  Title: 	CTT/ROOT
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Adds Constructive Type Theory to a database containing pure Isabelle. 
Should be executed in the subdirectory CTT.

To build system, enter Poly/ML and type
    PolyML.use "ROOT";
*)

writeln"Root file for Constructive Type Theory";

open PolyML;  (*essential when using make_database!*)

print_depth 1;  
use "syntax.ML";
use ".rules.ML";
use "resolve.ML";

print_depth 1;  
structure CTT_Syntax =  CTT_SyntaxFun(Syntax);
structure CTT_Rule = CTT_RuleFun
    (structure CTT_Syntax=CTT_Syntax and Pure=Pure);
structure CTT_Resolve = CTT_ResolveFun
    (structure CTT_Syntax=CTT_Syntax and CTT_Rule=CTT_Rule);

print_depth 0;  
open Pure;
open CTT_Resolve CTT_Rule CTT_Syntax;

Unify.printer := Syntax.prin syn;

print_depth 8;  
use "arith.ML";
use "bool.ML";
use "rew.ML";
