signature Object =
sig

(* OBJECT DEFINITION

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        24 Jan 1990

   Maintenance: Author


   DESCRIPTION

   Definition of an Object for use in MonoVectors, MonoRefVectors, etc.

   An Object provides a type T and functions for reading, parsing and
   comparing values of that type.


   SEE ALSO

   Sequence, RefSequence., MonoVector, MonoRefVector.
*)

(* TYPES *)

  type T


(* CONVERTERS *)

  val parse': string list ->
	      (T * string list, T Option * string list) Result
   (* parse' s; parses an Object prefix of s, if there is one,
      and returns that Object with the remainder of s. *)

  val parse:  string -> (T, T Option) Result
   (* parse s; parses an Object prefix of s, if there is one. *)

  val read: InStream -> (T, T Option) Result
   (* read s; reads an Object from s, if s begins with one. *)

  val string: T -> string
   (* string t; returns the string representation of t. *)


(* OBSERVERS *)

  val fixedWidth: bool
   (* fixedWidth; is true if the usual Ascii representation of type T uses
      a fixed number of characters for all values. *)

  val eq: T -> T -> bool
   (* eq x y; returns true if x and y are equal.  Usually this is x = y. *)

  val ne: T -> T -> bool
   (* ne x y; returns true if x and y are unequal.  Usually this is x <> y. *)

  val lt: T -> T -> bool
   (* lt x y; returns true if x is less than y. *)

  val le: T -> T -> bool
   (* le x y; returns true if x is less than or equal to y. *)

  val gt: T -> T -> bool
   (* gt x y; returns true if x is less than y. *)

  val ge: T -> T -> bool
   (* ge x y; returns true if x is less than or equal to y. *)
end
