
signature List =

(* LIST CONVERSION FUNCTIONS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        4 Oct 1989

   Maintenance: Author


   DESCRIPTION

   These functions are separated from the other basic functions on lists
   so that the other functions can be used by Vector, which is used in turn
   by StringType, which is used by InStream, which is used here.


   SEE ALSO

   ListPair
*)

sig

  include List'

  val version: real
   (* version = 0.1 *)

  type 'a T
    sharing type T = list

  val stringSep: string -> string -> string ->
                 ('a -> string) -> 'a list -> string

  val string: ('a -> string) -> 'a list -> string

  exception Sep of string * string * string * string

  val parseSepN: string -> string -> string ->
                 (string list -> ('a * string list, 'b) Result) ->
                 Nat -> string -> ('a list, 'a list Option) Result

  val parseSep: string -> string -> string ->
                (string list -> ('a * string list, 'b) Result) ->
                string -> ('a list, 'a list Option) Result

  val parse: (string list -> ('a * string list, 'b) Result) ->
             string -> ('a list, 'a list Option) Result

  val parseN: (string list -> ('a * string list, 'b) Result) ->
              Nat -> string -> ('a list, 'a list Option) Result

  val parseSepN': string -> string -> string ->
                 (string list -> ('a * string list, 'b) Result) ->
                 Nat -> string list ->
                 ('a list * string list, 'a list Option * string list) Result

  val parseSep': string -> string -> string ->
                 (string list -> ('a * string list, 'b) Result) ->
                 string list ->
                 ('a list * string list, 'a list Option * string list) Result

  val parse': (string list -> ('a * string list, 'b) Result) ->
              string list ->
              ('a list * string list, 'a list Option * string list) Result

  val parseN': (string list -> ('a * string list, 'b) Result) ->
               Nat -> string list ->
               ('a list * string list, 'a list Option * string list) Result

  val readSep: string -> string -> string ->
               (InStream -> ('a, 'b) Result) -> InStream ->
               ('a list, 'a list Option) Result

  val readSepN: string -> string -> string ->
               (InStream -> ('a, 'b) Result) -> Nat -> InStream ->
               ('a list, 'a list Option) Result

  val read: (InStream -> ('a, 'b) Result) -> InStream ->
            ('a list, 'a list Option) Result

  val readN: (InStream -> ('a, 'b) Result) -> Nat -> InStream ->
             ('a list, 'a list Option) Result
end
