signature General =
sig

(* GENERAL DEFINITIONS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	21 Sep 89


   DESCRIPTION

   Types, exceptions and functions that are widely used or that don't fit
   anywhere else.

   NOTES

   This would be the place to define the equality function, but that can't be
   redefined.
*)

  val version: real
   (* version = 0.1 *)


(* PERVASIVES *)

  exception Bind and Match and Interrupt

  type exn and unit

  val o: ('b -> 'c) * ('a -> 'b) -> ('a -> 'c)
  val <> : ''a * ''a -> bool

  (* The next two exceptions are used by the redefinition of the
     pervasive arithmetic operations. *)
  exception Overflow
  and OldDiv

(* TYPES *)

  datatype 'a Option = None | Some of 'a

  type Nat
    sharing type Nat = int

  datatype ('a, 'b) Result = OK of 'a | Fail of 'b


(* SYSTEM *)

  exception NotImplemented of string
   (* NotImplemented fn; raised if the function called fn isn't provided
      in this implementation of the library. *)
 
  exception Nat of string * int
   (* Nat (fn, n); raised if the function named fn is passed a negative
      integer n to an argument of type Nat. *)

  exception Io of string * string * string
   (* Io (fn, file, msg); raised if an error occurs when the function named fn
      is called with either the filename file or with a stream copnnected to
      that file.  The third argument is a system specific message - e.g.
      "file does not exist" or "permission denied". *)


(* FUNCTIONS *)

  val id: 'a -> 'a
   (* id x; returns x.  The identity function. *)

  val curry: ('a * 'b -> 'c) -> 'a -> 'b -> 'c
   (* curry f; (curry f) x y = f (x, y). *)

  val uncurry: ('a -> 'b -> 'c) -> ('a * 'b -> 'c)
   (* uncurry f; (uncurry f) (x, y) = f x y. *)

  val iterate: Nat -> ('a -> 'a) -> 'a -> 'a
   (* iterate n f;  performs self-composition of f, n times.
      In other words, iterate n f base = f (f ... (f base) ...),
      with n occurrences of f. *)
      
  val repeat: Nat -> ('a -> 'b) -> 'a -> unit
   (* repeat n f arg; applies f to arg n times, presumably for
      the side effects performed by f.  In other words,
      repeat n f arg = (f arg; ...; f arg; ()). *)

  val until: ('a -> bool) -> ('a -> 'a) -> 'a -> 'a
   (* until p f arg; returns f (f ...  (f arg) ...) for the smallest number
      of application of f such that p applioed to the result is true.
      f is applied at least once. *)

  val primRec: ('a -> Nat -> 'a) -> 'a -> Nat -> 'a
   (* primRec f init n; Primitive recursion.  Returns the nth application
      of f, starting from init.  Differs from iterate in the type of f. *)

end
