
signature Byte =
sig

(* BYTES

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance:	Author


   DESCRIPTION

   Functions on 8-bit bytes.


   NOTES

   This exists mainly to support ByteVectors and ByteRefVectors.
*)

  val version: real
   (* version = 0.1 *)


(* TYPES *)

  type Byte


(* OBJECT *)

  structure Object: Object

  type T

  val parse': string list ->
              (Byte * string list, Byte Option * string list) Result

  val parse:  string -> (Byte, Byte Option) Result

  val read: InStream -> (Byte, Byte Option) Result

  val string: Byte -> string

  val fixedWidth: bool
   (* fixedWidth = true. *)

  (* The comparison operators use ASCII ordering. *)

  val eq: Byte -> Byte -> bool

  val ne: Byte -> Byte -> bool

  val lt: Byte -> Byte -> bool

  val le: Byte -> Byte -> bool

  val gt: Byte -> Byte -> bool

  val ge: Byte -> Byte -> bool

end
