(*$Memo : RefVector GeneralTypes *)

loadSig "Memo";

structure Memo: Memo =

(* MEMO FUNCTION PACKAGE

   Created by:  K. Mitchell, LFCS, University of Edinburgh
   Date:        April 1989.

   Maintenance: Author
*)

struct

  val version = 0.1


(* MEMO FUNCTIONS *)

local
  exception Uninitialised;

  fun extend(a,newmax,v) =         (* extends a RefVector with more elements *)
      let val a' = RefVector.create newmax  v
       in (RefVector.copy 0 (RefVector.size a) a 0 a'; a') end

  fun xupdate(xa as  (r as ref a), i, v, expfn, nullvalue) =
      (RefVector.update i v a; a)
        handle RefVector.Update _ => 
          if i < 0 then raise General.Nat ("memo", i)
          else let val newsize = Int.max (i+1) (expfn(i+1))  in
         (r := extend(a,newsize,nullvalue); RefVector.update i v (!r); !r) end;

  fun xsub( (ref a), i) =                
      RefVector.sub(a, i) 
        handle RefVector.Sub _  => 
          if i < 0 then raise General.Nat ("memo", i) else raise Uninitialised;
in
  fun memo (expfn: Nat -> Nat) (inj: 'a -> Nat) f =
      let val answers = ref(RefVector.create 0 None)
          fun compute answers i =
              ( case xsub(answers, inj i) of
                  Some v => v 
                | None => raise Uninitialised )
              handle 
                Uninitialised =>
                  let val v = f (compute answers) i 
                   in ( xupdate(answers, inj i, Some v, expfn, None); 
                        v ) end
       in ( fn n => compute (ref(RefVector.create (inj n) None)) n,
            compute answers ) end;
end; (* local *)


fun memo2 expfn injx injy f = 
    memo  expfn injx (fn tf => fn x => #2(memo expfn injy (fn _ => f tf x)));

fun memo3 expfn injx injy injz f = 
    memo  expfn injx (fn tf => fn x => #2(memo expfn injy 
                     (fn _  => fn y => #2(memo expfn injz 
                     (fn _ => f tf x y)))));

end
