
structure ByteObject: Object =

(* BYTES

   Created by:	Dave Berry LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance:	Author
*)

struct

  val version = 0.1


(* TYPES *)

  type T = int


(* OBSERVERS *)

  val fixedWidth = true

  val lt = Int.lt
  val gt = Int.gt
  val le = Int.le
  val ge = Int.ge
  val eq = Int.eq
  val ne = Int.ne


(* CONVERTERS *)

  fun string b = chr b

  fun parse' [] = Fail (None, [])
  |   parse' (h::t) = OK (ord h, t)

  fun read i =
        case InStream.input1 i of
          "" => Fail None
  	| s  => OK (ord s)

  fun parse s =
	case parse' (explode s) of
	  OK (l, _) => OK l
        | Fail _ => Fail None
end
