(* Copyright (c) 1992 by Carnegie Mellon University *)

functor ConnLexFun
  (structure Tokens: Conn_TOKENS
   structure Interface :INTERFACE)=
   struct
    structure UserDeclarations =
      struct
structure Tokens = Tokens
type pos = Interface.pos
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult= (svalue,pos) token

fun line () = !Interface.line
fun eof () = Tokens.EOF (line(),line())
fun error e = output(std_out,
      "% Connections: (line "^(Interface.makeString(line()))^") "^e^"\n")
val charlist = ref ([""] :string list)
val numOffset = (ord "0")*111
val ascii'at = ord "@";
val quoteChar = "\"";
fun nullString () = charlist := [""];
fun addString (s:string) = charlist := s :: (!charlist);
fun makeString () = (implode(rev(!charlist)) before charlist := nil);
val comLevel = ref 0
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\009\009\009\009\009\009\009\009\009\043\045\009\009\009\009\009\
\\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\
\\043\009\042\009\009\009\009\010\040\009\009\009\009\009\009\009\
\\009\009\009\009\009\009\009\009\009\009\009\039\009\009\009\009\
\\009\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\
\\010\010\010\010\010\010\010\010\010\010\010\009\009\009\009\010\
\\009\010\010\010\010\033\010\010\010\027\010\010\010\010\018\010\
\\010\010\010\012\010\010\010\010\010\010\010\009\009\009\009\009\
\\009"
val s3 =
"\046\046\046\046\046\046\046\046\046\046\051\046\046\046\046\046\
\\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\
\\046\046\046\046\046\046\046\046\049\046\047\046\046\046\046\046\
\\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\
\\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\
\\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\
\\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\
\\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\046\
\\046"
val s5 =
"\052\052\052\052\052\052\052\052\052\052\066\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\065\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\053\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052"
val s7 =
"\067\067\067\067\067\067\067\067\067\069\070\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\069\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\068\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067"
val s10 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\013\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s13 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\014\011\011\011\011\011\000\000\000\000\000\
\\000"
val s14 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\015\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\016\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s16 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\017\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\019\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\020\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\021\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s21 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\022\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\023\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s23 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\024\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s24 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\025\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s25 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\026\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s27 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\028\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s28 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\029\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s29 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\030\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s30 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\031\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s31 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\032\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s33 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\034\011\011\000\000\000\000\000\
\\000"
val s34 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\035\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\036\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\037\011\011\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s37 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\011\000\000\000\000\000\000\000\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\000\000\000\011\
\\000\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\038\011\011\011\011\011\011\000\000\000\000\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\041\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s43 =
"\000\000\000\000\000\000\000\000\000\044\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\044\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\048\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s49 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\050\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s52 =
"\052\052\052\052\052\052\052\052\052\052\000\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\000\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\000\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\052\
\\052"
val s53 =
"\000\000\000\000\000\000\000\000\000\063\064\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\063\000\062\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\059\059\059\059\059\059\059\059\059\059\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\058\000\056\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\055\000\
\\000\000\000\000\054\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s56 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\057\057\057\057\057\057\057\057\057\057\057\057\057\057\057\057\
\\057\057\057\057\057\057\057\057\057\057\057\057\057\057\057\057\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\060\060\060\060\060\060\060\060\060\060\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\061\061\061\061\061\061\061\061\061\061\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [(N 53)], trans = s5},
{fin = [(N 53)], trans = s5},
{fin = [], trans = s7},
{fin = [], trans = s7},
{fin = [(N 47)], trans = s0},
{fin = [(N 40),(N 47)], trans = s10},
{fin = [(N 40)], trans = s10},
{fin = [(N 40),(N 47)], trans = s12},
{fin = [(N 40)], trans = s13},
{fin = [(N 40)], trans = s14},
{fin = [(N 40)], trans = s15},
{fin = [(N 40)], trans = s16},
{fin = [(N 27),(N 40)], trans = s10},
{fin = [(N 40),(N 47)], trans = s18},
{fin = [(N 40)], trans = s19},
{fin = [(N 40)], trans = s20},
{fin = [(N 40)], trans = s21},
{fin = [(N 40)], trans = s22},
{fin = [(N 40)], trans = s23},
{fin = [(N 40)], trans = s24},
{fin = [(N 40)], trans = s25},
{fin = [(N 37),(N 40)], trans = s10},
{fin = [(N 40),(N 47)], trans = s27},
{fin = [(N 40)], trans = s28},
{fin = [(N 40)], trans = s29},
{fin = [(N 40)], trans = s30},
{fin = [(N 40)], trans = s31},
{fin = [(N 13),(N 40)], trans = s10},
{fin = [(N 40),(N 47)], trans = s33},
{fin = [(N 40)], trans = s34},
{fin = [(N 40)], trans = s35},
{fin = [(N 40)], trans = s36},
{fin = [(N 40)], trans = s37},
{fin = [(N 20),(N 40)], trans = s10},
{fin = [(N 6),(N 47)], trans = s0},
{fin = [(N 47)], trans = s40},
{fin = [(N 45)], trans = s0},
{fin = [(N 42),(N 47)], trans = s0},
{fin = [(N 4),(N 47)], trans = s43},
{fin = [(N 4)], trans = s43},
{fin = [(N 1)], trans = s0},
{fin = [(N 100)], trans = s0},
{fin = [(N 100)], trans = s47},
{fin = [(N 98)], trans = s0},
{fin = [(N 100)], trans = s49},
{fin = [(N 93)], trans = s0},
{fin = [(N 95)], trans = s0},
{fin = [(N 53)], trans = s52},
{fin = [(N 82)], trans = s53},
{fin = [(N 62)], trans = s0},
{fin = [(N 65)], trans = s0},
{fin = [], trans = s56},
{fin = [(N 75)], trans = s0},
{fin = [(N 68)], trans = s0},
{fin = [], trans = s59},
{fin = [], trans = s60},
{fin = [(N 80)], trans = s0},
{fin = [(N 71)], trans = s0},
{fin = [(N 59)], trans = s0},
{fin = [(N 56)], trans = s0},
{fin = [(N 49)], trans = s0},
{fin = [(N 51)], trans = s0},
{fin = [(N 90)], trans = s0},
{fin = [(N 88),(N 90)], trans = s0},
{fin = [(N 86),(N 90)], trans = s0},
{fin = [(N 84)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val C = STARTSTATE 3;
val F = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val S = STARTSTATE 5;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  1 => (Interface.nextLine(); lex())
| 100 => (continue())
| 13 => (Tokens.IMPORT(line(),line()))
| 20 => (Tokens.EXPORT(line(),line()))
| 27 => (Tokens.SOURCE(line(),line()))
| 37 => (Tokens.NAMESPACE(line(),line()))
| 4 => (lex())
| 40 => (Tokens.ID(yytext,line(),line()))
| 42 => (nullString(); YYBEGIN S; lex())
| 45 => (YYBEGIN C; comLevel := 1; continue())
| 47 => (error ("ignoring bad character "^yytext); lex())
| 49 => (YYBEGIN INITIAL;
		  Tokens.STRING (makeString(),line(),line()))
| 51 => (error "unclosed string"; Interface.nextLine();
		  YYBEGIN INITIAL; Tokens.STRING (makeString(),line(),line()))
| 53 => (addString(yytext); lex())
| 56 => (Interface.nextLine(); YYBEGIN F; lex())
| 59 => (YYBEGIN F; lex())
| 6 => (Tokens.SEMI(line(),line()))
| 62 => (addString("\t"); lex())
| 65 => (addString("\n"); lex())
| 68 => (addString("\\"); lex())
| 71 => (addString(quoteChar); lex())
| 75 => (addString(chr(ordof(yytext,2)-ascii'at)); lex())
| 80 => (let val x = ordof(yytext,1)*100+ordof(yytext,2)*10+ordof(yytext,3)-numOffset
  in
    if x>255
      then error "illegal ascii escape"
      else addString(chr x);
    lex()
  end)
| 82 => (error "illegal string escape"; lex())
| 84 => (Interface.nextLine(); lex())
| 86 => (lex())
| 88 => (YYBEGIN S; lex())
| 90 => (error "unclosed string"; YYBEGIN INITIAL;
	    Tokens.STRING (makeString(),line(),line()))
| 93 => (inc comLevel; continue())
| 95 => (Interface.nextLine(); continue())
| 98 => (dec comLevel;
	    if !comLevel=0 then YYBEGIN INITIAL else (); continue())
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
