/*

	IDL:    Bernard Sufrin, Oxford
		X toolkit base
		@(#)idlxt.c	1.1 92/09/25 12:49:56
*/

#       include <stdio.h>
#       include <X11/Intrinsic.h>
#       include <X11/StringDefs.h>
#       include <X11/Xaw/Command.h>
#       include <X11/Xaw/Box.h>
#       include "idlbase.h"

static  int     suspicious;

void IdlEvents(client_data, fid, id)
  XtPointer client_data;
  int       *fid;
  XtInputId *id;
{ int waiting;
  while (waiting=idlcaninput ()) idlevent();
  idlflush();
  /*
	This (mess) is to ensure that we don't leave uncleaned-up
	servers buzzing if the client dies intestate. It would be much more
	straightforward to ask if there's anything at the other
	end of the pipe, but SunOs and X documentation being what they are
	dictate that expediency is the better part of elegance.
  */
  if (waiting==0)
     { suspicious++;
       if (suspicious>800) /* wait a while before believing it */
	{ fprintf(stderr, "[Client died]\n");
	  exit(2);
	}
     }
  else
     { suspicious=0; }
}

void IdlErrors(client_data, fid, id)
  XtPointer client_data;
  int       *fid;
  XtInputId *id;
{ fprintf(stderr, "[Warning: client side pipe closed]\n");
  exit(2);
}

extern
void    XtIdlMainLoop(app_context, topLevel)
	XtAppContext    app_context;
	Widget          topLevel;
{       XtInputId idi=XtAppAddInput(app_context, idlinputchannel(),
				   XtInputReadMask, IdlEvents,
				  NULL);
	XtInputId ide=XtAppAddInput(app_context, idlinputchannel(),
				   XtInputExceptMask, IdlErrors,
				   NULL);
	while (idlcontinue)
	{ XEvent e;
	  XtAppNextEvent(app_context, &e);
	  XtDispatchEvent(&e);
	};


	XtRemoveInput(idi);
	XtRemoveInput(ide);
}

