(* for SML/NJ 0.74 *)

functor SMLToolDefFun () :TOOLDEF = struct

val toolName = "sml"

val processor = ref ""
val targetNamer = ref (fn (pathname:string) =>  (pathname^".bin"))

fun loadSource (group:SourceGroup.group) sourceName targetName =
  System.Compile.loadSource sourceName

fun genTarget (group:SourceGroup.group) sourceName targetName =
  System.Compile.genTarget (sourceName, targetName)

fun loadTarget (group:SourceGroup.group) sourceName targetName =
  System.Compile.loadTarget targetName

fun compileSource (group:SourceGroup.group) sourceName targetName =
  System.Compile.compile (sourceName, targetName)

fun checkLoad (group:SourceGroup.group) sourceName targetName =
  if System.Compile.validTarget targetName
    then loadTarget group sourceName targetName
    else loadSource group sourceName targetName

fun validTarget (group:SourceGroup.group) sourceName targetName =
  System.Compile.validTarget targetName

end
