functor LexStuffFun
  (structure Tokens :ML_TOKENS
   structure Ascii :ASCII
   structure ErrorMsg :ERRORMSG
   sharing type ErrorMsg.pos = int
) :LEXSTUFF = struct

structure ErrorMsg = ErrorMsg
type pos = ErrorMsg.pos
type svalue = Tokens.svalue
type lexarg = {comLevel : int ref, 
	       lineNum : int ref,
	       linePos : int list ref, (* offsets of lines in file *)
               charlist : string list ref,
               stringstart : int ref, (* start of current string or comment*)
	       err :ErrorMsg.pos2complainer}
type arg = lexarg
type ('a,'b) token = ('a,'b) Tokens.token

fun make'lexarg (complain :ErrorMsg.pos2complainer) :lexarg =
  {comLevel=ref 0, lineNum=ref 0, linePos=ref [], stringstart=ref 0,
   charlist=ref (nil :string list), err=complain}

val eof = fn ({comLevel,err,linePos,stringstart,lineNum,charlist}) => 
	   let val pos = Integer.max(!stringstart+2, hd(!linePos))
	    in if !comLevel>0
                 then err (!stringstart,pos)
                          ErrorMsg.COMPLAIN "unclosed comment" 
                 else ();
	       Tokens.EOF(pos,pos)
	   end	

val ascii'zero = ord "0";
val ascii'dquote = ord "\"";
fun addString (charlist,s:string) = charlist := s :: (!charlist)
fun makeString charlist = (implode(rev(!charlist)) before charlist := nil)
fun makeInt sign s =
    revfold (fn (c,a) => sign(a*10, ord c - ascii'zero)) (explode s) 0
fun makeHexInt sign s = let
      fun digit d = if (d < Ascii.uc_a) then (d - Ascii.zero)
	    else (10 + (if (d < Ascii.lc_a) then (d - Ascii.uc_a) else (d - Ascii.lc_a)))
      in
	revfold (fn (c,a) => sign(a*16, digit(ord c))) (explode s) 0
      end

end
