/* les de'clarations de types Lisp en C */


typedef int LL_FIX;

typedef int LL_FLOAT;

/* 
   Comme C ne connai^t pas les types polymorphes, il faut se rabbatre
   sur la de'claration suivante pour les objets Lisp.

typedef union {
     struct LL_SYMBOL *ll_symbol;
     struct LL_CONS   *ll_cons;
     struct LL_STRING *ll_string;
     struct LL_VECTOR *ll_vector;
            LL_FIX     ll_fix;
            LL_FLOAT   ll_float;
} LL_OBJECT;

   C n'autorise he'las pas le passage d'une union comme argument de fonctions
   (me^me si cette union a pour taille un pointeur!).

   On en arrive donc a` l'horreur suivante\ :
 */

typedef char *LL_OBJECT;

struct LL_SYMBOL {
     LL_OBJECT  ll_cval;
     LL_OBJECT  ll_plist;
     LL_OBJECT  ll_fval;
     LL_OBJECT  ll_alink;
     LL_OBJECT  ll_pkgc;
     LL_OBJECT  ll_oval;
     char       ll_ftype;
     char       ll_ptype;
     short      ll_pad;
     LL_OBJECT  ll_pname;

};
struct LL_CONS {
     LL_OBJECT  ll_car;
     LL_OBJECT  ll_cdr;

};
 /*
    C n'autorise pas les structures de taille variable.
 
    Le champ  ll_strfil  contient le premier caracte`re de la chai^ne
    Lisp. Les autres caracte`res sont conse'cutifs a` celui-ci dans
    la me'moire.

 Exemple\ : impression d'une chai^ne Lisp
 
   voir(s) struct LL_STRING *s; {
       write(1, &((s->ll_strobj)->ll_strfil), (s->ll_strobj)->strsize);
   }
 */

struct LL_STRING {
     struct {
        struct LL_STRING *ll_strarr;
        int               ll_strsiz;
        char              ll_strfil;
     }  *ll_strobj;
     LL_OBJECT ll_strtyp;
};

 /*
   Me^me remarque pour le champ ll_vecfil que pour le champ ll_strfil
 */

struct LL_VECTOR {
     struct{
         struct LL_VECTOR *ll_vecarr;
         int               ll_vecsiz;
         LL_OBJECT         ll_vecfil;
     } *ll_vecobj;
     LL_OBJECT ll_vectyp;
};


/* Les types symbolique des arguments */

#define LLT_T 0      /* Objet quelconque */
#define LLT_FIX 1    /* Entier */
#define LLT_FLOAT 2  /* Flottant */
#define LLT_STRING 3 /* Chaine de caracteres */
#define LLT_VECTOR 4 /* Vecteur */

/* Les fonctions permettant l'interface C --->  Lisp */

/*  struct LL_SYMBOL *getsym (pname) char *pname; */
struct LL_SYMBOL *getsym();

/*  void pusharg (ll_type, value) int ll_type; any value; */
void pusharg();

/*  LL_OBJECT lispcall (ll_type, narg, symbol)
         int ll_type, narg; struct LL_SYMBOL *symbol;  */
                                              
LL_OBJECT lispcall();

