/*
   File: XtArgs.h
   Defines macros for easy argument list handling
*/
#ifndef MaxArgs
#define MaxArgs 20
#endif
#ifndef MaxCallbacks
#define MaxCallbacks 20
#endif

static XtCallbackRec WidgetCallbacks[MaxCallbacks];
static Arg WidgetArgs[MaxArgs];
static int NrOfCallbacks, FirstCallback;
static int NrOfArgs;

/*
   Now define some access macros on the widget arguments
*/
#define StartArgs NrOfArgs = NrOfCallbacks = FirstCallback = 0
#define SetArg(r,v) XtSetArg (WidgetArgs [NrOfArgs], r, v); NrOfArgs++

#define SetCallback(func, value) \
	WidgetCallbacks [NrOfCallbacks].callback = (XtCallbackProc) func;\
	WidgetCallbacks [NrOfCallbacks++].closure = (caddr_t) value

#define UseCallback(resource) \
	SetCallback (NULL, NULL); \
	SetArg (resource, &WidgetCallbacks [FirstCallback]);\
	FirstCallback = NrOfCallbacks

#define Callback(proc) \
	SetCallback(proc,NULL); \
	UseCallback(XtNcallback)

#define UseArgs WidgetArgs, NrOfArgs
#define NoArgs NULL,0
