/*
   File: utils.c
   Low level utilities.
*/
#include <stdio.h>		/* standard UNIX I/O libary */

#include <tmc.h>		/* the tm support library */
#include <cvr.h>		/* personal support library */

#include "uflat2const.h"
#include "tmcode.h"
#include "utils.h"		/* low level utility functions */

/* Search for symbol 's' in the list 'l' and return TRUE if
   found or FALSE otherwise.
 */
bool member_symbol_list (s, l)
 symbol s;
 symbol_list l;
	{ register int ix;
	  for (ix = 0; ix < l -> sz; ix++)
	     if (l -> arr[ix] == s) return (TRUE);
	  return (FALSE);
	};

/* Given a symbol list 'l' and a symbol 's', append it to the
 * list if it isn't already there.
 */
void add_symbol_list (l, s)
 symbol_list l;
 symbol s;
	{ if (member_symbol_list (s, l)) return;
	  app_symbol_list (l, s);
	};

void docrash (msg, f, l)
 char *msg;
 char *f;
 int l;
	{ fprintf (stderr, "%s(%d): %s.\n", f, l, msg);
	  exit(1);
	};
