/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: config.h
 *
 * Some configuration constants.
 */
#define STRBUFSZ 1024    /* Maximum size of a string */

#ifdef GOT_DECL
#undef GOT_DECL
#endif

#ifdef IBM 
#define TMREALLOC(p,n) realloc((char *)(p),n)
#define TMFREE(p) free((char *)(p))
#define GOT_DECL
#endif

#ifdef hpux
#include <malloc.h>
#include <string.h>
extern void exit();
#ifdef hp9000s300
/* The defines below are necessary to stop complaints on various machines
 * about incompatible types to realloc() and free(). On hpux v7.0 a void *
 * are used, but not interpreted as a neutral pointer type. AAAARGGHHH.
 */
#define TMREALLOC(p,n) realloc((void *)(p),n)
#define TMFREE(p) free((void *)(p))
#else
#define TMREALLOC(p,n) realloc((char *)(p),n)
#define TMFREE(p) free((char *)(p))
#endif
#define GOT_DECL
#endif

#ifdef __TURBOC__
#include <stdlib.h>
#include <string.h>
#define TMREALLOC realloc
#define TMFREE free
#define GOT_DECL
#endif

#ifdef APOLLO
#include <strings.h>
#define GOT_DECL
extern char *malloc();
extern free();
extern exit();
#define TMREALLOC(p,n) realloc((char *)(p),n)
#define TMFREE(p) free((char *)(p))
#endif

#ifndef GOT_DECL
#ifdef BSD
#include <strings.h>
#else
#include <string.h>
#endif
extern char *malloc();
extern free();
extern exit();
#define TMREALLOC(p,n) realloc((char *)(p),n)
#define TMFREE(p) free((char *)(p))
#endif
