/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* template file:      tmds.ht
   datastructure file: ds.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)
 */

/* ---- start of /users/reeuwijk/esprit/lib/calu.ht ---- */
/* Definition C datastructures (Version for array list).

   template file:      /users/reeuwijk/esprit/lib/calu.ht
   datastructure file: ds.ds
   tm version:         27 (Mon Sep 10 17:30:58 METDST 1990)
 */

typedef struct str_constructor_list *constructor_list;
typedef struct str_ds_list *ds_list;
typedef struct str_field_list *field_list;
typedef struct str_string_list *string_list;
typedef struct str_ds *ds;
typedef struct str_constructor *constructor;
typedef struct str_field *field;

#define dsNIL (ds)0
#define constructorNIL (constructor)0
#define fieldNIL (field)0
#define constructor_listNIL (constructor_list)0
#define ds_listNIL (ds_list)0
#define field_listNIL (field_list)0
#define string_listNIL (string_list)0

#define DsCons u.ue_DsCons
#define DsTuple u.ue_DsTuple

typedef enum en_tags_ds {
    TAGDsCons, TAGDsTuple
} tags_ds;


/* Structure for constructor DsCons */
typedef struct str_DsCons {
    string ctypename;
    constructor_list conslist;
} C_DsCons;

/* Structure for constructor DsTuple */
typedef struct str_DsTuple {
    string ttypename;
    field_list tuplefields;
} C_DsTuple;

struct str_ds {
    tags_ds tag;
    union uni_ds {
	C_DsCons ue_DsCons;
	C_DsTuple ue_DsTuple;
    } u;
};

struct str_constructor {
    string conname;
    field_list confields;
};

struct str_field {
    int listlev;
    string sename;
    string setype;
};

struct str_constructor_list {
    unsigned int sz;
    unsigned int room;
    constructor *arr;
};

struct str_ds_list {
    unsigned int sz;
    unsigned int room;
    ds *arr;
};

struct str_field_list {
    unsigned int sz;
    unsigned int room;
    field *arr;
};

struct str_string_list {
    unsigned int sz;
    unsigned int room;
    string *arr;
};


#if defined( __STDC__ ) && __STDC__>0
/* new_<cons> and new_<type> routines */
extern ds new_DsCons( string, constructor_list );
extern ds new_DsTuple( string, field_list );
extern constructor new_constructor( string, field_list );
extern field new_field( int, string, string );
extern ds_list new_ds_list( void );
extern constructor_list new_constructor_list( void );
extern field_list new_field_list( void );
extern string_list new_string_list( void );

/* room_<type>_list() routines */

/* app_<type>_list() routines */
extern void app_ds_list( ds_list, ds );
extern void app_constructor_list( constructor_list, constructor );
extern void app_field_list( field_list, field );
extern void app_string_list( string_list, string );

/* append_<type>_list() routines */

/* ins_<type>_list() routines */

/* del_<type>_list() routines */

/* conc_<type>_list() routines */

/* concat_<type>_list() routines */

/* fre_<type>_list() routines */

/* rfre_<type>_list() routines */
extern void rfre_ds_list( ds_list );
extern void rfre_string_list( string_list );

/* print_<type>() routines */
extern void print_ds_list( ds_list );

/* fprint_<type>() routines */

/* rdup_<type>() routines */

/* fscan_<type>() routines */

/* cmp_<type>() routines */

/* misc. functions */
extern void flush_ds( void );
extern void stat_ds( FILE * );
#else
/* new_<cons> and new_<type> routines */
extern ds new_DsCons();
extern ds new_DsTuple();
extern constructor new_constructor();
extern field new_field();
extern ds_list new_ds_list();
extern constructor_list new_constructor_list();
extern field_list new_field_list();
extern string_list new_string_list();

/* room_<type>_list() routines */

/* app_<type>_list() routines */
extern void app_ds_list();
extern void app_constructor_list();
extern void app_field_list();
extern void app_string_list();

/* append_<type>_list() routines */

/* ins_<type>_list() routines */

/* del_<type>_list() routines */

/* conc_<type>_list() routines */

/* concat_<type>_list() routines */

/* fre_<type>_list() routines */

/* rfre_<type>_list() routines */
extern void rfre_ds_list();
extern void rfre_string_list();

/* print_<type>() routines */
extern void print_ds_list();

/* fprint_<type>() routines */

/* rdup_<type>() routines */

/* fscan_<type>() routines */

/* cmp_<type>() routines */

/* misc. functions */
extern void flush_ds();
extern void stat_ds();
#endif
/* ---- end of /users/reeuwijk/esprit/lib/calu.ht ---- */
