/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* file: tm.c
   main for 'tm': datastructure generation
 */

#include "tmdefs.h"

extern void free();

#ifdef lint
int errno;
char *sys_errlist[1];
int sys_nerr = 0;
char _ctype_[1];
#endif

#include <tmc.h>

#include "tmvers.h"
#include "tmds.h"
#include "tmstring.h"
#include "debug.h"
#include "tmerror.h"
#include "tmfn.h"
#include "tmlex.h"
#include "tmmisc.h"
#include "tmtplelm.h"
#include "tmtrans.h"
#include "tmvar.h"
#include "tmglobal.h"
#include "tmlibpath.h"

ds_list parse();
char *prognm;
static FILE *tplfile;

/* Table of debugging flags plus associated information.

   Table is ended by an entry with flagchar '\0'
 */
struct flagadrinfo flagtab[] = {
    { 'e', &sevaltr, "tracing of string evaluations" },
    { 'f', &fntr, "tracing of function evaluations" },
    { 'l', &listing, "list parsetree" },
    { 'm', &maintr, "tracing of main actions" },
    { 's', &prstat, "statistics" },
    { 'v', &vartr, "variable tracing" },
    { 'x', &lextr, "tracing of lexical analyzer" },
    { 'y', &yydebug, "tracing of YACC parser" },
    { '\0', &yydebug, "" }
};

/* Scan command line arguments and options as passed by 'argc' and 'argv'. */
static void scanargs( argc, argv )
 int argc;
 char **argv;
{
    int printusage = FALSE;
    int exitcode = 0;
    int op;

    dsfilename = CHARNIL;
    tplfilename = CHARNIL;
    verbose = FALSE;
    prognm = argv[0];
    if( prognm[0] == 0 ) prognm = "tm";
    argv++;
    argc--;
    while( argc>0 ){
	if( argv[0][0] != '-' ) break;
	op = argv[0][1];
	switch( op ){
	    case 'd':
		setdbflags( &argv[0][2], flagtab );
		break;

	    case 'h':
	    case 'H':
		printusage = TRUE;
		exitcode = 0;
		break;

	    case 'v':
		verbose = TRUE;
		break;

	    case '?':
	    default:
		printusage = TRUE;
		exitcode = 1;
		break;
	}
	argc--;
	argv++;
    }
    if( printusage ){
	fprintf( stdout, "Tm version %s.\n", tmvers );
	fprintf( stdout, "Compiled at %s on '%s'.\n", tmdate, tmhost );
	fprintf(
	    stdout,
	    "Usage: %s[-hv] [-d<debugflags>] [<dsfile>] [<infile>]\n",
	    argv[0]
	);
	dbhelp( flagtab );
	exit( exitcode );
    }
    if( argc>0 ){
	dsfilename = new_string( argv[0] );
	argc--;
	argv++;
    }
    if( argc>0 ){
	tplfilename = new_string( argv[0] );
	argc--;
	argv++;
    }
    if( argc>0 ){
	fprintf(
	    stdout,
	    "%s: only one input file allowed\n",
	    argv[0]
	);
	exit( 1 );
    }
}

int main( argc, argv )
 int argc;
 char **argv;
{
    init_error();
    init_lex();
    init_var();
    scanargs( argc, argv );
    dbreport( flagtab );
    maintrace( "parsing" );
    if( dsfilename != CHARNIL ){
	FILE *dsfile;

	dsfile = ckfopen( dsfilename, "r" );
	allds = parse( dsfile );
	(void) fclose( dsfile );
    }
    else{
	dsfilename = new_string( "<none>" );
	allds = new_ds_list();
    }
    if( tplfilename != CHARNIL ){
	tplfile = ckfopen( tplfilename, "r" );
    }
    else{
	tplfile = stdin;
	tplfilename = new_string( "<stdin>" );
    }
    if( listing ){
	setprint( stdout, 2, 80 );
	print_ds_list( allds );
    }
    errcheck();
    maintrace( "translation" );
    setvar( "tmvers", tmvers );
    setvar( "tmdate", tmdate );
    setvar( "tmhost", tmhost );
    setvar( "libpath", libpath );
    setvar( "verbose", (verbose ? "1" : "0" ) );
    setvar( "pathsep", PATHSEPSTR );
    translate( tplfile, stdout);
    flushvar();
    (void) fclose( tplfile );
    end_lex();
    if( prstat ){
	rfre_ds_list( allds );
	fre_string( dsfilename );
	fre_string( tplfilename );
	flush_ds();
	stat_ds( statstream );
	stat_lex( statstream );
	stat_string( statstream );
	stat_tplelm( statstream );
	stat_var( statstream );
    }
    errcheck();
    exit( 0 );
    return( 0 );
}
