/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: testprog.c
 *
 * Test of library programs.
 */

/* Unix libraries */
#include <stdio.h>

/* the test library */
#include "config.h"
#include "tmc.h"

#if defined( __STDC__ ) && __STDC__ >0
void testprintopt ( void );
void testbrac ( void );
void testcons ( void );
void testunsigned ( void );
void testint ( void );
void testdouble ( void );
void teststring ( void );
void testtmbool ( void );
void ftestint ( FILE *f );
void ftestunsigned ( FILE *f );
void fteststring ( FILE *f );
void main ( void );
#endif

/* testprintopt: test printopt routines */
void testprintopt()
{
    int k;
    int i;
    int j;

    openlist();
    closelist();
    opentuple();
    printword( "tuple1" );
    printword( "24" );
    closetuple();
    opencons();
    printword( "Cons1" );
    closecons();
    for( k=0; k<12; k+=3 ){
	opencons();
	printword( "Cons2" );
	opencons();
	printword( "Cons3" );
	for( i=1; i<k; i++ ){
	    openlist();
	    for( j=0; j<i; j++ ) printword( "42" );
	    closelist();
	}
	closecons();
	opentuple();
	printword( "tuple" );
	for( i=1; i<k; i++ ){
	    openlist();
	    for( j=0; j<i; j++ ) printword( "42" );
	    closelist();
	}
	closetuple();
	closecons();
    }
    printword( "Top" );
    printword( "level" );
    printword( "printword()." );
}

/* Test of fscanopenbrac() and fscanclosebrac().
 * Read open brackets and match with close brackets until
 * a group of 0 pairs is encountered. Write the brackets
 * to the output file with the opencons() and closecons()
 * functions.
 */
void testbrac()
{
    int bracs;
    int i;

    do{
	bracs = fscanopenbrac( stdin );
	for( i=0; i<bracs; i++ ){
	    opencons();
	    printword( "Bractest" );
	    printword( "42" );
	}
	if( fscanclosebrac( stdin, bracs ) ){
	    fprintf( stderr, "*** Error: %s\n", tmerrmsg );
	}
	for( i=0; i<bracs; i++ ) closecons();
    } while( bracs != 0 );
}

/* Test of fscancons(). Read and write constructors until one
   with name "StopFscanCons" is encountered.
 */
void testcons()
{
    char buf[1000];

    opencons();
    printword( "Constest" );
    openlist();
    do{
	if( fscancons( stdin, buf ) ){
	    fprintf( stderr, "*** Error: %s\n", tmerrmsg );
	}
	printword( buf );
    } while( strcmp( buf, "StopFscanCons" ) != 0 );
    closelist();
    closecons();
}

/* Test of print_unsigned() and fscan_unsigned(): read and write
   unsigned's until one with value 42 is encountered.
 */
void testunsigned(){
    unsigned int u;

    opencons();
    printword( "Unsignedtest" );
    do {
	if( fscan_unsigned( stdin, &u ) ){
	    fprintf( stderr, "*** Error: %s\n", tmerrmsg );
	}
	print_unsigned( u );
    } while( u != 42 );
    closecons();
}

/* Test of print_int() and fscan_int(): read and write int's until
   one with value -1 is encountered.
 */
void testint(){
    int i;

    opencons();
    printword( "Inttest" );
    do {
	if( fscan_int( stdin, &i ) ){
	    fprintf( stderr, "*** Error: %s\n", tmerrmsg );
	}
	print_int( i );
    } while( i != -1 );
    closecons();
}

/* test cmp_double() */
void testdouble()
{
    int res;
    double a = 1.2e3;

    res = cmp_double( (double) 1.0, (double) -1.0 );
    if( res <= 0 ){
	fprintf(
	    stderr,
	    "*** Error: cmp_double( (double) 1.0, (double) -1.0 ) = %d\n",
	    res
	);
    }
    res = cmp_double( (double) -42.0, (double) -1.0 );
    if( res >= 0 ){
	fprintf(
	    stderr,
	    "*** Error: cmp_double( (double) -42.0, (double) -1.0 ) = %d\n",
	    res
	);
    }
    res = cmp_double( a, a );
    if( res != 0 ){
	fprintf(
	    stderr,
	    "*** Error: cmp_double( a , a ) = %d\n",
	    res
	);
    }
}

void teststring()
{
    char *s;
    int stop;
    int i;
    char *sbuf[10];

    for( i=0; i<10; i++ ){
	sbuf[i] = new_string( "testing 1,2,3...." );
    }
    for( i=0; i<10; i++ ){
	fre_string( sbuf[i] );
    }
    opencons();
    printword( "Stringouttest" );
    print_string( "" );
    print_string( "Test" );
    closecons();
    opencons();
    printword( "Stringintest" );
    stop = 0;
    do {
	if( fscan_string( stdin, &s ) ){
	    fprintf( stderr, "*** Error: %s\n", tmerrmsg );
	}
	print_string( s );
	if( strcmp( s, "STOP"  ) == 0 ) stop = 1;
	fre_string( s );
    } while( stop == 0 );
    closecons();
}

void testtmbool()
{
    tmbool b;

    opencons();
    printword( "Tmboolouttest" );
    print_tmbool( TMTRUE );
    print_tmbool( TMFALSE );
    do {
	if( fscan_tmbool( stdin, &b ) ){
	    fprintf( stderr, "*** Error: %s\n", tmerrmsg );
	}
	print_tmbool( b );
    } while( b );
    closecons();
}

/* Test of fprint_int() */
void ftestint( f )
 FILE *f;
{
    fputs( "fprint_int: [", f );
    fprint_int( f, 12 );
    fputs( " ", f );
    fprint_int( f, 0 );
    fputs( " ", f );
    fprint_int( f, -42 );
    fputs( "]\n", f );
}

/* Test of fprint_unsigned() */
void ftestunsigned( f )
 FILE *f;
{
    fputs( "fprint_unsigned: [", f );
    fprint_unsigned( f, 12 );
    fputs( " ", f );
    fprint_unsigned( f, 0 );
    fputs( " ", f );
    fprint_unsigned( f, 42 );
    fputs( "]\n", f );
}

void fteststring( f )
 FILE *f;
{
    fputs( "fprint_string: [", f );
    fprint_string( f, "blabla" );
    fputs( " ", f );
    fprint_string( f,  "" );
    fputs( " ", f );
    fprint_string( f,  "reutel" );
    fputs( "]\n", f );
}

int main()
{
    tmlineno = 1;
    setprint( stdout, 4, 80 );
    testprintopt();
    testbrac();
    testcons();
    testint();
    testunsigned();
    testdouble();
    teststring();
    testtmbool();
    ftestint( stdout );
    ftestunsigned( stdout );
    fteststring( stdout );
    stat_string( stderr );
    fprintf( stdout, "tmlineno=%d\n", tmlineno );
    tmfatal( __FILE__, __LINE__, "test of 'tmfatal'" );
    exit( 0 );
    return( 0 );
}
