/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: prstr.c
 * C. van Reeuwijk
 */

#include <stdio.h>
#include <ctype.h>

#include "tmc.h"

#define BACKSLASH '\\'

#define STRBUFSZ 1000

/* definition of 'print' for a 'string' */
void print_string( s )
 register char *s;
{
    char buf[STRBUFSZ+10];
    register char *bufp;
    register char *bufend;
    register int c;

    if( s == (char *)0 ){
	printword( "<nil>" );
	return;
    }
    bufp = buf;
    bufend = &buf[STRBUFSZ];
    *bufp++ = '"';
    while( *s != '\0' ){
	c = *s++;
	while( c<0 ) c += 256;
	if( c == BACKSLASH || c == '"' ){
	    *bufp++ = BACKSLASH;
	    *bufp++ = c;
	    continue;
	}
	if( c>=' ' && c<='~' ){
	    *bufp++ = c;
	    continue;
	}
	switch( c ){
	    case '\b': *bufp++ = BACKSLASH; *bufp++ = 'b'; break;
	    case '\f': *bufp++ = BACKSLASH; *bufp++ = 'f'; break;
	    case '\n': *bufp++ = BACKSLASH; *bufp++ = 'n'; break;
	    case '\r': *bufp++ = BACKSLASH; *bufp++ = 'r'; break;
	    case '\t': *bufp++ = BACKSLASH; *bufp++ = 't'; break;
	    case '\v': *bufp++ = BACKSLASH; *bufp++ = 'v'; break;
	    default:
		(void) sprintf( bufp, "\\%03o", (c & 0xff) );
		while( *bufp != '\0' ) bufp++;
	}
	if( bufp>=bufend ){
	    tmfatal( __FILE__, __LINE__, "string too long" );
	}
    }
    *bufp++ = '"';
    *bufp = '\0';
    printword( buf );
}
