/* 
   Copyright (C) 1990 C van Reewijk, email: dutentb.uucp!reeuwijk

This file is part of GLASS.

GLASS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GLASS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GLASS; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* File: fneedc.c
 * Last modified: CvR
 *
 * Ensure that the next non-blank character in the input stream is the
 * required character. Else complain.
 */

/* Standard UNIX libraries. */
#include <stdio.h>
#include <ctype.h>

/* The header of this library */
#include "tmc.h"
#include "config.h"

/* Skip all `isspace()' characters, and try to character 'needc'.
   Compose an error message in 'tmerrmsg' and return 1 if this
   is not possible, else return 0.
 */
int tmfneedc( f, needc )
 FILE *f;
 int needc;
{
    register int c;
    char charstr[15];
    char needcharstr[15];

    if( fscanspace( f ) ) return( 1 );
    c = getc( f );
    if( c != needc ){
	if( c == EOF ){
	    (void) sprintf( charstr, "EOF" );
	}
	else if( c>=' ' && c<='~' ){
	    (void) sprintf( charstr, "char '%c'", c );
	}
	else {
	    (void) sprintf( charstr, "char 0x%02x", c );
	}
	if( c>=' ' && c<='~' ){
	    (void) sprintf( needcharstr, "'%c'", needc );
	}
	else {
	    (void) sprintf( needcharstr, "0x%02x", needc );
	}
	(void) sprintf(
	    tmerrmsg,
	    "Expected character %s but got %s",
	    needcharstr,
	    charstr
	);
	return( 1 );
    }
    return( 0 );
}
