/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* File: tc.c  (termcap routines)
   Author: Simon Klaver
   
   Functions for cursor-key recognition and screen attributes
*/

#include <curses.h>
#include "tctypes.h"

extern char *malloc();

void addkeystring (ks, keystr, keyid)
  keystrings ks;
  char *keystr;
  int keyid;
{
  ks->keystr[ks->n] = (char *) malloc (10);
  strcpy (ks->keystr[ks->n], keystr); 
  ks->keyid[ks->n] = keyid;
  ks->n = ks->n + 1;
}

void initkeystrings (ks, termcapbuf)
  keystrings *ks;
  char **termcapbuf;   /* pointer to pointer to termcap buffer */
{
  char *kl, *kr, *kd, *ku;
  *ks = (keystrings) malloc(sizeof(**ks));
  (*ks)->n = 0;
  kl = (char*) tgetstr ("kl", termcapbuf);
  kr = (char*) tgetstr ("kr", termcapbuf);
  kd = (char*) tgetstr ("kd", termcapbuf);
  ku = (char*) tgetstr ("ku", termcapbuf);
  addkeystring (*ks, (kl+1), KEY_LEFT);
  addkeystring (*ks, (kr+1), KEY_RIGHT);
  addkeystring (*ks, (kd+1), KEY_DOWN);
  addkeystring (*ks, (ku+1), KEY_UP);
#include "keystrings.h"
  /* printf ("Initkeystrings: %d key definitions stored.\n", (*ks)->n); */
}


void printwithesc (s)
  char *s;
{
  char *str;
  str = s;
  while (*str != '\0') {
    if (((int)(*str))==27)
      printf ("^[");
    else
      printf ("%c", *str);
    str = str + 1;
  }
}

void printkeystrings (ks)
  keystrings ks;
{
  int i;
  printf ("Keystrings are:\n");
  for (i=0; i<ks->n; i++) {
    printwithesc (ks->keystr[i]);
    printf ("  : keycode %d", ks->keyid[i]);
    printf ("\n");
  }
}

bool contains (str1, str2)
  char *str1, *str2;
/* Is str2 a beginning of str1 ? */
{
  bool equal;
  int i;
  equal = TRUE;
  i = 0;
  while ( (str1[i] != (char) 0) &&
          (str2[i] != (char) 0) &&
          (str1[i] == str2[i])
        ) {
    i = i + 1;
  } 
  if ( (str1[i] != str2[i]) &&
       (str2[i] != (char) 0)
     ) 
    return (FALSE);
  else
    return (TRUE);
}


void findkeystr (ks, keystr, keyid, found, maybefound)
  keystrings ks;
  char *keystr;
  int  *keyid;
  bool *found, *maybefound; 
{
  int i;
  i = 0;
  printf ("Findkeystr: \"%s\" ", keystr);
  *found = FALSE;
  *maybefound = FALSE;
  while ( (i<ks->n) &&
          (*found == FALSE)
        ) {
    if (contains (ks->keystr[i], keystr) == TRUE)
      *maybefound = TRUE;  
    if (strcmp (ks->keystr[i], keystr) == 0) {
      *found = TRUE;
      *keyid = ks->keyid[i];
    }
    i = i + 1;
  }
  printf (" keyid = %d, ", *keyid);
  if (*found == TRUE) printf ("found = TRUE");
               else  printf ("found = FALSE");
  if (*maybefound == TRUE) printf (", maybefound = TRUE");
               else  printf (", maybefound = FALSE");
  printf ("\n");
}


static attrstrings as;

void printattrstrings ()
{
  printf ("Enter blinking: ");
  printwithesc (as->mb); printf ("\n");
  printf ("Enter bold: ");
  printwithesc (as->md); printf ("\n");
  printf ("Turn off all attributes: ");
  printwithesc (as->me); printf ("\n");
  printf ("Enter reverse: ");
  printwithesc (as->mr); printf ("\n");
}

void initattrstrings (termcapbuf)
  char **termcapbuf;
{
  as = (attrstrings) malloc(sizeof(*as));
  as->mb = (char *) tgetstr ("mb", termcapbuf);
  as->md = (char *) tgetstr ("md", termcapbuf);
  as->me = (char *) tgetstr ("me", termcapbuf);
  as->mr = (char *) tgetstr ("mr", termcapbuf);
}

#ifdef SUN 
bool isdigit (c)
  char c;
{ 
  if ( (c >= '0') &&
       (c <= '9')
     )
    return(TRUE);
  else
    return(FALSE);
}
#endif

void printtermcapstr (s)
  char *s;
{
  int i, padcount;
  padcount = 0;
  i = 0;
  while (isdigit(s[i]) == TRUE) {
    padcount = 10*padcount + (int)s[i] - (int)'0';
    i = i + 1;
  }
  addstr (s+i);
  for (i=0; i<padcount; i++) addstr ("\0"); 
}


void beep()
{
  printf (BEEP);
}

void flash()
{
  printf (FLASH);
}

