
/*

    This file is a part of the GLASS source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  S.J. Klaver, R Doesborg
              email: simon@sagan.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* File: handlemenu.c
   Author: R. Doesborg
*/

#include <stdio.h>
#include <tmc.h>
#include <curses.h>
#include "tctypes.h"
#include "menuds.h"
#include "gconst.h"
#include "dprocs.h"
#include "actionds.h"
#include "performact.h"
#include "checkglue.h"
#include "errnum.h"
#include "tools.h"
#include "globalvars.h"
#include "handleparms.h"
#include "stackprocs.h"

/* Unix calls: */
extern char *malloc();

int menulength (ml)
  menuitemspec_list ml;
{
  int total = 0;
  int index;

  for (index=0; index<ml->sz; index++)
    total = total + strlen(ml->arr[index]->itemname) + 2;
  total = total - 2;
  return(total);
}

int display_menu (mp, inr)
  Menu mp;
  int inr;
{
  int pos;
  int ix;
  menuitemspec_list l;
  int err = 0;
  int namepos;

  wclear_screen(stdscr);
  namepos = (LINELENGTH - strlen(mp->menuname)) / 2;
  wdisplay_string(stdscr, mp->menuname, 0, namepos, BOLD);
  pos = (LINELENGTH - menulength(mp->menuitems)) / 2;
  l = mp->menuitems;
  for (ix=0; ix<l->sz && !err; ix++)
  {
    l->arr[ix]->linpos = pos;
    if (ix != inr)
      err = wdisplay_keyword(stdscr, l->arr[ix]->itemname, MENULINE, pos,
                            NORMAL, l->arr[ix]->idchar, l->arr[ix]->idpos);
    else
      err = wdisplay_keyword(stdscr, l->arr[ix]->itemname, MENULINE, pos,
                            REVERSE, l->arr[ix]->idchar, l->arr[ix]->idpos);
    pos = pos + strlen(l->arr[ix]->itemname) + 2;
  }
  return(err);
}

void convert_act (inact, outact)
  actionspec inact;
  actionptr outact;
{
  if (inact->tag == TAGDo) {
    if (((Do)inact)->actionno == -1) {
      outact->action = actQUIT;
    }
    else {
      outact->action = actDO;
      outact->menact = ((Do)inact)->actionno;
    }
  }
  else if (inact->tag == TAGShow) {
    outact->action = actSHOW;
    outact->menact = ((Show)inact)->menuid;
  }
  else if (inact->tag == TAGAsk) {
    outact->action = actASK;
    outact->menact = ((Ask)inact)->parid;
  }
  else if (inact->tag == TAGTofile) {
    outact->action = actTOFILE;
    outact->menact = ((Tofile)inact)->parid;
    outact->comm = ((Tofile)inact)->filename;
  }
  else {
    outact->action = actSYS;
    outact->comm = ((Sys)inact)->command;
  }
}

void convert_actions (inacts, outacts)
  actionspec_list inacts;
  actionptr *outacts;
{
  int i;
  actionptr hulp;

  *outacts = NULL;
  for (i=inacts->sz-1; i>=0; i--) {
    if (*outacts == NULL) {
      *outacts = (actionptr)malloc(sizeof(**outacts));
      convert_act(inacts->arr[i], *outacts);
      (*outacts)->next = NULL;
    }
    else {
      hulp = (actionptr)malloc(sizeof(*hulp));
      convert_act(inacts->arr[i], hulp);
      hulp->next = *outacts;
      *outacts = hulp;
    }
  }
}

/* !!!!!! IMPORTANT NOTE !!!!!!
   The function get_act depends on the constant definitions of
   'curses'. So if the software is ported to X/Windows, this
   functions must be changed too.
*/
actionptr get_act (cm, ci)
  Menu cm;
  int *ci;
{
  actionptr act;
  int key;
  int stop = 0;
  int newit;
  menuitemspec it;
  actionspec_list tempact;
  int err = 0;

  while (!stop) {
    key = wget_key(stdscr);
    stop = 1;
    if ((key >= 'a' && key <= 'z') || (key>= 'A' && key <= 'Z')) {
      if (cm->menuid == mainmenuid && (key == 'x' || key == 'X')) {
        act = (actionptr)malloc(sizeof(*act));
        act->action = actQUIT;
      }
      else {
        newit = find_item (cm, key);
        if (newit < 0) {
          wdisplay_error(stdscr, errILLKEY);
          stop = 0;
        }
        else {
          it = cm->menuitems->arr[*ci];
          err = wdisplay_keyword(stdscr, it->itemname, MENULINE, it->linpos,
                                NORMAL, it->idchar, it->idpos);
          *ci = newit;
          it = cm->menuitems->arr[*ci];
          err = wdisplay_string(stdscr, it->itemname, MENULINE, it->linpos, 
                                REVERSE);
          tempact = cm->menuitems->arr[*ci]->action;
          convert_actions(tempact, &act);
        }
      }
    }
    else {
      switch (key) {
        case KEY_UP:
          act = (actionptr)malloc(sizeof(*act));
          act->action = actUP;
          act->next = NULL;
          break;
        case KEY_LEFT:
          act = (actionptr)malloc(sizeof(*act));
          act->action = actLEFT;
          act->next = NULL;
          break;
        case KEY_RIGHT:
          act = (actionptr)malloc(sizeof(*act));
          act->action = actRIGHT;
          act->next = NULL;
          break;
        case KEY_RETURN:
          tempact = cm->menuitems->arr[*ci]->action;
          convert_actions(tempact, &act);
          break;
        case KEY_ESCAPE:
          act = (actionptr)malloc(sizeof(*act));
          act->action = actUP;
          act->next = NULL;
          break;
        case ' ':
          act = (actionptr)malloc(sizeof(*act));
          act->action = actRIGHT;
          act->next = NULL;
          break;
        case '!':
          endwin();
          printf ("\n\nLogout to return to GLUE.\n"); 
          if (cshell) 
            system ("csh");
          else
            system ("sh");
          printf ("\nBack in GLUE.\n");
          wrefresh(curscr); 
          crmode(); noecho(); nonl();
          stop = 0;
          break;
        default:
          wdisplay_error(stdscr, errILLKEY);
          stop = 0;
          break;
      }
    }
  }
  return(act);
} /* get_act */

void handle_actions (gl, cm, ci, alp, quit)
  gluefile gl;
  Menu *cm;
  int *ci;
  actionptr alp;
  int *quit;
{
  menuitemspec it;
  int err = 0;
  actionptr halp;

  *quit = 0;
  halp = alp;
  while (halp != NULL && !(*quit)) {
    switch (halp->action) {
      case actLEFT:
        it = (*cm)->menuitems->arr[*ci];
        err = wdisplay_keyword(stdscr, it->itemname, MENULINE, it->linpos,
                              NORMAL, it->idchar, it->idpos);
        if (*ci==0) *ci = (*cm)->menuitems->sz;
        (*ci)--;
        it = (*cm)->menuitems->arr[*ci];
        err = wdisplay_string(stdscr, it->itemname, MENULINE, it->linpos,
                               REVERSE);
        break;
      case actRIGHT:
        it = (*cm)->menuitems->arr[*ci];
        err = wdisplay_keyword(stdscr, it->itemname, MENULINE, it->linpos,
                              NORMAL, it->idchar, it->idpos);
        (*ci)++;
        if (*ci == (*cm)->menuitems->sz) *ci = 0;
        it = (*cm)->menuitems->arr[*ci];
        err = wdisplay_string(stdscr, it->itemname, MENULINE, it->linpos,
                              REVERSE);
        break;
      case actUP:
        {
          int mid;
 
          if ((*cm)->menuid == mainmenuid)
            wdisplay_error(stdscr, errNOQUST);
          else {
            err = pull_element(&mid, ci);
            if (!err) *cm = find_menu(gl, mid);
            if (!err) err = display_menu (*cm, *ci);
          }
        } break;
      case actSHOW:
        err = push_element((*cm)->menuid, *ci);
        if (!err) *cm = find_menu(gl, halp->menact);
        if (!err) *ci = 0;
        if (!err) err = display_menu(*cm, *ci);
        break;
      case actQUIT:
        *quit = 1;
        break;
      case actDO:
        execute_action(gl, halp->menact);
        switchtounbuffered();
        touchwin(stdscr);
        wrefresh(curscr);
        break;
      case actSYS:
        execute_command(gl, halp->comm);
        switchtounbuffered();
        touchwin(stdscr);
        wrefresh(curscr);
        break;
      case actASK:
        handle_parms(gl, halp->menact, PARMLINE);
        refresh();
        switchtounbuffered();
        touchwin(stdscr);
        wrefresh(curscr);
        break;
    }
    halp = halp->next;
  }
}

int start_menu (gl, mmi)
  gluefile gl;      /* Data structure of menu description */
  int mmi;          /* Id of first menu */
{
  int err = 0;
  Menu cm;
  int ci;
  actionptr alp;
  int quit = 0;

  init_screen();
  cm = find_menu(gl, mmi);
  err = (cm == (Menu)0);
  if (!err) display_menu(cm, 0);
  ci = 0;
  while (!quit)
  { 
    alp = get_act(cm, &ci);
        /* Action is chosen; `alp' is pointer to actionlist */
    handle_actions(gl, &cm, &ci, alp, &quit);
  }
  wexit_screen(stdscr);
}
