/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef READINPUT
extern affix _generationtime;
void readinput(sarg_count, sarguments)
int             sarg_count;
char          **sarguments;
{
  int             arg_count = sarg_count;
  char          **arguments = sarguments;
  int             input_file_set = false;
  int             read_input = true;
  int             output_file_set = false;
  char           *arg_zero = *arguments, *minput;
  output_to_stdout = false;
  stack_bottum = (int) &output_file_set;
  for (arguments += arg_count - 1; arg_zero != *arguments; arguments -= 1) {
    switch (**arguments) {
    case '-':
      switch (*(1+*arguments)) {
      case '\0':
        if (output_file_set && !input_file_set) {
          input_from_stdin = true;
          inputfile = stdin;
          input_file_set = true;

        } else if (!output_file_set) {
          output_to_stdout = true;
          output_file_set = true;

        } else {
          fprintf(stderr, " %s: `-' ignored\n", arg_zero);
        }
        break;
      case 'a':
        sscanf(*arguments + 2, "%d", &abq_level);
        break;
      case 'b':
      case 'B':
          fprintf(stderr, " %s: not compiled with backtrace option.\n", 
                              arg_zero);
        break;
      case 'l':
        sscanf(*arguments + 2, "%d", &ll_count);
       
        ll_mode = true;
        break;
      case 'h':
        sscanf(*arguments + 2, "%d", &afhsize);
        afhsize = afhsize * 512000;
        break;
      case 'c':
        sscanf(*arguments + 2, "%d", &cssize);
        cssize = cssize * 512000;
        break;
      case 'q':
        sscanf(*arguments + 2, "%d", &q_size);
        q_size = q_size  <<10;
        q_size = q_size *100;
        break;
      case 't':
        if (*(*arguments +1) == '\0') 
             interesting_level_number = -1;
        else 
             sscanf(*arguments + 2, "%d", &interesting_level_number);
        break;
      case 'r':
        report_stacksize = true;
        break;
      case 'v':
        fprintf(stderr, "%s: Version %s.\n",arg_zero, _generationtime.t);
        break;
      case '-':
          input_file_set = false;
        read_input = false;
        break;

      default: ;
/*
 *       fprintf(stderr, "%s: Unknown option `-%c' (ignored).\n",arg_zero,
 *                                     **arguments);
 */
      }
      break;
    default:
      {
        if (output_file_set && !input_file_set) {
          char           *fname = in_file_name,
          *arg = *arguments;
          while (*arg != '\0')
            *fname++ = *arg++;
          *fname++ = '\0';
          inputfile = fopen(in_file_name, "r");
          if (inputfile == NULL) {
            fprintf(stderr, "%s: \"%s\" No such file.\n", 
                       arg_zero,in_file_name);
            exit(1);
          }
          input_file_set = true;
        
        } else if (!output_file_set) {
          char           *fname = out_file_name,
          *arg = *arguments;
          while (*arg != '\0')
            *fname++ = *arg++;
          *fname++ = '\0';
          output_file_set = true;

        } else {
          fprintf(stderr, "Usage: %s  [infile|-] [outfile|-]\n",
              arg_zero);
          exit(1);
        }
        break;
      }
    }
  }
  if ((output_file_set) && (!input_file_set)) {
    if (output_to_stdout) {
      inputfile = stdin;
      input_from_stdin = true;
      (void) sprintf(in_file_name, "-\0");
    
    } else {
          output_to_stdout = true;
          inputfile = fopen(out_file_name, "r");
         (void) sprintf(in_file_name, "%s\0", out_file_name);
    }

    if (inputfile == NULL) {
      fprintf(stderr, "%s: \"%s\" No such file.\n", arg_zero,in_file_name);
      exit(1);
    }
    input_file_set = true;
  }
  if (!output_file_set) {
    output_to_stdout = true;
    output_file_set = true;
  }
  if (!input_file_set) {
    inputfile = stdin;
    input_file_set = true;
    input_from_stdin = true;
  }
  affix_heap = NULL;
  affix_heap = (affix *) malloc(12*afhsize);
  if (affix_heap == NULL) {
    fprintf(stderr, "%s: No %d bytes available for affix storage!\n", 
                       arg_zero,afhsize*12);
    exit(1);
  }
  afx_top = affix_heap + afhsize -1;
  
  minput = (char *) malloc(cssize);
  input = minput +4;
  if (input == NULL) {
    fprintf(stderr, "%s: No %d bytes available for character storage!\n", 
                       arg_zero,cssize);
    exit(1);
  }
  
  cstore_top = input + cssize -256;

  q_stack = NULL;
  q_stack = (cont *) malloc(4*q_size);
  if (q_stack == NULL) {
    fprintf(stderr, "%s: No %d bytes available for continuation stack !\n", 
                       arg_zero,q_size*4);
    exit(1);
  }
  q_top = q_stack + q_size -1;
  
  nrofchars = 0;
  set_ip_start_pos = input;
  set_ip_start_num = 1;
  set_line_pos = input;
  set_line_num = 1;
  set_file_name = in_file_name; 
  ip = input;
  *(ip - 1) = '\n';
  *(ip - 2) = '\n';
  if (ll_mode) {nrofchars = 10000; return;}

  if (read_input) {
	while (!feof(inputfile)) {
		*ip++ = getc(inputfile);
		nrofchars += 1;
		if (ip > cstore_top) cstore_overflow();
	}
	limitip = ip;
	*--ip = '\0';
	if (!input_from_stdin)
		*--ip = '\0';
	else clearerr(stdin);
	ip = input;
  }
  else {
	*ip++ == '\0';
	*ip++ == '\0';
	*ip++ == '\0';
	*ip++ == '\0';
	nrofchars = 5;
	limitip = ip;
	ip = input;
  }
}
#endif
