/*

    This file is a part of the GLAMMAR source distribution 
    and therefore subjected to the copy notice below. 
    
    Copyright (C) 1989,1990  Eric Voss, ericv@cs.kun.nl 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation version 1

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ge1.h"
#ifdef SET_AND_TEST_LIMITS
afx_overflow()  {
    fprintf(stderr, "Glammar: affix heap overflow.\n\
 Hard Limit was %d bytes.\n\
 Increase with -hn (n=1 = 6Mb, n=2 =12Mb, ...);\n",
     (char *)afx_top - (char *) affix_heap);
    exit(1);
}
  
need_more_qstack()  {
    fprintf(stderr, "Glammar: continuation stack overflow.\n\
 Hard Limit was %d bytes.\n\
 Increase with -qn (n=1 = 100Kb, n=2 =200Kb, ...);\n", q_size);
    exit(1);
}

cstore_overflow()  {
    fprintf(stderr, "Glammar: char store overflow.\n\
 Hard Limit was %d bytes.\n\
 Increase with -cn (n=1 = 512Kb, n=2 =1Mb, ...);\n",cstore_top - input);
    exit(1);
}

void set_and_test_limits(stk_size, memo_flag)
   int             stk_size,
                   memo_flag;
{
   /* test inputsize */
   if (memo_flag)
         if (nrofchars > runtime_input_size-4 ) {
            fprintf(stderr, "Input size too large (max %d chars)\n",
            runtime_input_size-4);
            exit(1);
         }
}
#endif

#ifdef TRACE
char *spaces = "                                "; 
int begin1_trace(ntname)
char           *ntname;
{
  if (interesting_level_number == -1) return level++;
  if (level >= interesting_level_number) {
    int id = (q-q_stack)>>2;
    char *ids = spaces +32 - (id &31);
    if (id >0)
      fprintf(stdout, "%d ",id);
    fprintf(stdout, "%d %s==> %s ", level++,ids, ntname);
    fflush(stdout);
  } else
    level += 1;
}
void begin2_trace() {
  if (interesting_level_number == -1) return;
  if (level > interesting_level_number) {
    if ((ip > limitip) || (ip < input)) 
      fprintf(stdout, " '%c' META\n",*ip);
    else if (*ip != '\0') 
      fprintf(stdout, "%d '%c'\n", ip - input, *ip);
    else
      fprintf(stdout, " EOF\n");
    fflush(stdout);
  }
}

int try_trace_list_affix();
void printa ();
void trace_affix(afx)
register AFFIX afx;
{
  if (interesting_level_number == -1) return;
  if (level > interesting_level_number) {
    printf("(");
    if (afx == nil);
    if (try_trace_list_affix(afx));
    else
      printa(stdout, afx);
    printf(") ");
  }
}

int try_trace_list_affix(A)
register AFFIX A;
{
  affix   *cell = (affix *) -1;
/*  GET_CELL_ADDR(cell,(A -> t));  */
  if (A == 0) {
    printf("(null)");
    return true;
   }
	{ 
		register char *d = (char *) & cell; 
		register char *rc = (A -> t); 
		if ( (rc[0] == '\001') && 
                     (rc[5] == '\001') && 
                     (rc[6] == '\000')) { 
			d[0] = rc [1] ; 
			d[1] = rc [2]; 
			d[2] = rc [3]; 
			d[3] = rc[4]; 
		} else cell = (affix *) -1;
	};
  if ((long) cell != -1) {
    printa(stdout, cell->l);
    printf("*");
    printa(stdout, cell->r);
    return true;
  }
  return false;
}


begintrace(ntname)
char           *ntname;
{
  if (interesting_level_number == -1) return level++;
  if (level > interesting_level_number) {
    if (*ip != '\0')
      fprintf(stdout, "%d ==> %s %d,%d '%c'\n", level++, ntname, mip - input, ip
          - input, *ip);
    else
      fprintf(stdout, "%d ==> %s EOF\n", level++, ntname);
    fflush(stdout);
  } else
    level += 1;
}

endtrace(pct, ntname)
char           *ntname;
int             pct;
{
  if (interesting_level_number == -1) return ;
  if (level > interesting_level_number) {
    int id = (q-q_stack)>>2;
    char *ids = spaces +32 - (id &31);
    if (id >0)
      fprintf(stdout, "%d ",id);
    if (pct == parsecount) {
      if ((ip > limitip) || (ip < input)) 
        fprintf(stdout, "%d %s<-- %s META '%c'\n", --level, ids,ntname,*ip);
      else if (*ip != '\0')
        fprintf(stdout, "%d %s<-- %s %d,%d '%c'\n", --level, ids,ntname, mip -
            input, ip - input, *ip);
      else
        fprintf(stdout, "%d %s<-- %s EOF\n", --level, ids,ntname);
    } else {
      if ((ip > limitip) || (ip < input)) 
        fprintf(stdout, "%d %s<++ %s META '%c'\n", --level, ids,ntname,*ip);
      else if (*ip != '\0')
        fprintf(stdout, "%d %s<++ %s %d,%d '%c'\n", --level,ids, ntname, mip -
            input, ip - input, *ip);
      else
        fprintf(stdout, "%d %s<++ %s EOF\n", --level,ids, ntname);
    }
    fflush(stdout);
  } else
    level -= 1;
}

void ambiguous_trace(pct, act, ntname)
char           *ntname;
int            *pct,
*act;
{
  if (*pct < parsecount) {
    if (*act != 0)
      fprintf(stderr, "runtime message: `%s' ambiguous, %d, '%c'\n", ntname, ip
          - input, *ip);
    else
      *act += 1;
    *pct = parsecount;
  }
}
#endif

void     result();
#ifdef FOUND
void  found() {
  if (*ip == '\0') {
    parsecount += 1;
    result();
    if (parsecount >= abq_level)
      exit(0);
  }
  q += 1;
}
#endif

