/*
   File: codestorage.c
   stores code until it may be written to disk
*/
#include <stdio.h>
#include <tmc.h>
#include <cvr.h>
#include "codestorage.h"

/*
   Code generation is driven by traversing the abstract syntax trees.
   This means that code generated for a definition must be stored
   temporarily until the code of all of its local definitions has
   been written to disk, after which it may also be written to disk.
*/
#define MaxDepth 40			/* Max depth of definitions */
#define MaxLength 80			/* Max length of line */

typedef struct coderec
	{ string code;
	  struct coderec *next;
	} *codelist;
#define codelistNIL ((codelist)0)


static codelist code_head = codelistNIL;
static codelist code_tail = codelistNIL;
char line_buffer [MaxLength];		/* Code just generated */

/*
   Enter new code
*/
void enter_new_code (s)
 char *s;
	{ codelist cl = (codelist) ckmalloc (sizeof (struct coderec));
	  cl -> code = new_string (s);
	  cl -> next = codelistNIL;
	  if (code_tail == codelistNIL)
	     { code_head = code_tail = cl; }
	  else
	     { code_tail -> next = cl;
	       code_tail = cl;
	     };
	};

/*
   Enter new routine: set up administration to store code
*/
void init_codebuffer (f)
 FILE *f;
	{ if (code_tail != codelistNIL)
	     { fprintf (stderr, "Code buffer not empty, flushed\n");
	       flush_codebuffer (f);
	     };
	  enter_new_code ("");
	};

/*
   Write code of current routine to disk
*/
void flush_codebuffer (f)
 FILE *f;
	{ codelist ptr;
	  ptr = code_head;
	  while (ptr != codelistNIL)
	     { codelist ptr2 = ptr;
	       ptr = ptr -> next;
	       fprintf (f, "%s\n", ptr2 -> code);
	       free (ptr2 -> code);
	       free (ptr2);
	     };
	  code_tail = codelistNIL;
	};
